/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2;

import java.util.Objects;
import java.util.Optional;

public class JSGLR2Request {
    public final String input;
    public final String fileName;
    public final String startSymbol;
    public final int recoveryIterationsQuota;
    public final int succeedingRecoveryOffset;
    public final int recoveryTimeout;
    public final Optional<Integer> completionCursorOffset;
    public final boolean reportAmbiguities;
    public static final int DEFAULT_RECOVERY_ITERATIONS_QUOTA = 5;
    public static final int DEFAULT_SUCCEEDING_RECOVERY_OFFSET = 10;
    public static final int DEFAULT_RECOVERY_TIMEOUT = 1000;

    public JSGLR2Request(String input) {
        this(input, "");
    }

    public JSGLR2Request(String input, String fileName) {
        this(input, fileName, null);
    }

    public JSGLR2Request(String input, String fileName, String startSymbol) {
        this(input, fileName, startSymbol, 5, 10, 1000, Optional.empty(), false);
    }

    public JSGLR2Request(String input, String fileName, String startSymbol, int recoveryIterationsQuota, int succeedingRecoveryOffset, int recoveryTimeout, Optional<Integer> completionCursorOffset, boolean reportAmbiguities) {
        this.input = input;
        this.fileName = fileName;
        this.startSymbol = startSymbol;
        this.recoveryIterationsQuota = recoveryIterationsQuota;
        this.succeedingRecoveryOffset = succeedingRecoveryOffset;
        this.recoveryTimeout = recoveryTimeout;
        this.completionCursorOffset = completionCursorOffset;
        this.reportAmbiguities = reportAmbiguities;
    }

    public JSGLR2Request(String input, String fileName, String startSymbol, int recoveryIterationsQuota, int succeedingRecoveryOffset, int recoveryTimeout, Optional<Integer> completionCursorOffset) {
        this(input, fileName, startSymbol, recoveryIterationsQuota, succeedingRecoveryOffset, recoveryTimeout, completionCursorOffset, false);
    }

    public boolean isCacheable() {
        return !"".equals(this.fileName);
    }

    public boolean isCompletion() {
        return this.completionCursorOffset.isPresent();
    }

    public JSGLR2Request withCompletion(Optional<Integer> completionCursorOffset) {
        return new JSGLR2Request(this.input, this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.recoveryTimeout, completionCursorOffset, this.reportAmbiguities);
    }

    public JSGLR2Request withAmbiguitiesReporting(boolean reportAmbiguities) {
        return new JSGLR2Request(this.input, this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.recoveryTimeout, Optional.empty(), reportAmbiguities);
    }

    public CachingKey cachingKey() {
        if (!this.isCacheable()) {
            throw new IllegalStateException("This JSGLR2Request is not cacheable");
        }
        return new CachingKey(this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.recoveryTimeout);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSGLR2Request that = (JSGLR2Request)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startSymbol, that.startSymbol) && this.recoveryIterationsQuota == that.recoveryIterationsQuota && this.succeedingRecoveryOffset == that.succeedingRecoveryOffset && this.recoveryTimeout == that.recoveryTimeout && this.completionCursorOffset.equals(that.completionCursorOffset) && this.reportAmbiguities == that.reportAmbiguities;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.recoveryTimeout, this.completionCursorOffset, this.reportAmbiguities);
    }

    public static class CachingKey {
        final String fileName;
        final String startSymbol;
        final int recoveryIterationsQuota;
        final int succeedingRecoveryOffset;
        final int recoveryTimeout;

        CachingKey(String fileName, String startSymbol, int recoveryIterationsQuota, int succeedingRecoveryOffset, int recoveryTimeout) {
            this.fileName = fileName;
            this.startSymbol = startSymbol;
            this.recoveryIterationsQuota = recoveryIterationsQuota;
            this.succeedingRecoveryOffset = succeedingRecoveryOffset;
            this.recoveryTimeout = recoveryTimeout;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachingKey that = (CachingKey)o;
            return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startSymbol, that.startSymbol) && this.recoveryIterationsQuota == that.recoveryIterationsQuota && this.succeedingRecoveryOffset == that.succeedingRecoveryOffset && this.recoveryTimeout == that.recoveryTimeout;
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.recoveryTimeout);
        }
    }
}

