/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.BottomupTreeBuilder;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.imploder.TopdownTreeBuilder;

public class CycleParseNode
extends AbstractParseNode {
    private static final AbstractParseNode[] NO_CHILDREN = new AbstractParseNode[0];
    private ParseNode target;
    private transient AbstractParseNode nonAmbiguousTarget = null;

    public CycleParseNode(ParseNode target) {
        super(target.getLine(), target.getColumn());
        this.target = target;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    @Override
    public AbstractParseNode[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public Object toTreeBottomup(BottomupTreeBuilder builder) {
        return builder.buildCycle(this.getTargetLabel());
    }

    @Override
    public Object toTreeTopdown(TopdownTreeBuilder builder) {
        return builder.buildTreeCycle(this);
    }

    private AbstractParseNode getNonAmbiguousTarget() {
        if (this.nonAmbiguousTarget != null) {
            return this.nonAmbiguousTarget;
        }
        this.nonAmbiguousTarget = this.target;
        while (this.target.isAmbNode()) {
            this.nonAmbiguousTarget = this.target.getChildren()[0];
        }
        return this.nonAmbiguousTarget;
    }

    public int getTargetLabel() {
        if (this.getNonAmbiguousTarget().isParseNode()) {
            return ((ParseNode)this.getNonAmbiguousTarget()).getLabel();
        }
        return -1;
    }

    @Override
    public void reject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringShallow() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "cycle(" + this.target + ")";
    }

    @Override
    public boolean isParseProductionChain() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CycleParseNode other = (CycleParseNode)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public int getLabel() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getNonAmbiguousTarget().isEmpty();
    }

    @Override
    public AbstractParseNode getLeft() {
        return this.target.getLeft();
    }

    @Override
    public boolean isLayout() {
        return this.target.isLayout();
    }

    @Override
    public boolean isIgnoreLayout() {
        return this.target.isIgnoreLayout();
    }

    @Override
    public boolean isPlaceholderInsertionNode() {
        return this.target.isPlaceholderInsertionNode();
    }

    @Override
    public boolean isLiteralCompletionNode() {
        return this.target.isLiteralCompletionNode();
    }
}

