/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import org.spoofax.jsglr.client.ActionItem;
import org.spoofax.jsglr.client.RangeList;
import org.spoofax.jsglr.client.Reduce;

public class Action
implements Serializable {
    static final long serialVersionUID = -2742456888004361679L;
    protected RangeList ranges;
    protected ActionItem[] items;

    public Action(RangeList ranges, ActionItem[] items) {
        this.ranges = ranges;
        this.items = items;
    }

    public ActionItem[] getActionItems() {
        return this.items;
    }

    public boolean accepts(int currentToken) {
        return this.ranges.within(currentToken);
    }

    public int getSingularRange() {
        return this.ranges.getSingularRange();
    }

    public int getFirstCharValue() {
        return this.ranges.getFirstRangeElement();
    }

    public boolean rejectable() {
        ActionItem[] actionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionItem ai = actionItemArray[n2];
            if (ai.type == 1) {
                Reduce r = (Reduce)ai;
                if (r.status == 1) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean hasPrefer() {
        ActionItem[] actionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionItem ai = actionItemArray[n2];
            if (ai.type == 1) {
                Reduce r = (Reduce)ai;
                if (r.status == 2) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean hasAvoid() {
        ActionItem[] actionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionItem ai = actionItemArray[n2];
            if (ai.type == 1) {
                Reduce r = (Reduce)ai;
                if (r.status == 4) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("action(");
        sb.append(this.ranges);
        sb.append(", [");
        int i = 0;
        while (i < this.items.length) {
            sb.append(this.items[i]);
            if (i < this.items.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("])");
        return sb.toString();
    }
}

