/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr;

import java.util.LinkedList;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class STRSGLR_anno_location
extends AbstractPrimitive {
    private static final String NAME = "STRSGLR_anno_location";
    private static final int FIRST_LINE = 1;
    private static final int FIRST_COLUMN = 1;

    protected STRSGLR_anno_location() {
        super(NAME, 0, 1);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        if (tvars[0].getTermType() != 1 || !"parsetree".equals(((IStrategoAppl)tvars[0]).getConstructor().getName()) || tvars[0].getSubtermCount() != 2) {
            return false;
        }
        env.setCurrent(this.annoLocation(env.getFactory(), (IStrategoAppl)tvars[0]));
        return true;
    }

    public IStrategoTerm annoLocation(ITermFactory factory, IStrategoAppl parseTree) {
        Object top = Tools.termAt(parseTree, 0);
        Object metadata = Tools.termAt(parseTree, 1);
        top = new AsfixAnnoLocation(factory).traverse((IStrategoTerm)top);
        return factory.makeAppl(factory.makeConstructor("parsetree", 2), new IStrategoTerm[]{top, metadata});
    }

    private class AsfixAnnoLocation {
        private int line = 1;
        private int column = 1;
        private final ITermFactory factory;
        private final IStrategoTerm layout;
        private final IStrategoConstructor appl;
        private final IStrategoConstructor amb;
        private final IStrategoConstructor location;

        public AsfixAnnoLocation(ITermFactory factory) {
            this.factory = factory;
            this.layout = factory.makeAppl(factory.makeConstructor("cf", 1), factory.makeAppl(factory.makeConstructor("opt", 1), factory.makeAppl(factory.makeConstructor("layout", 0), new IStrategoTerm[0])));
            this.appl = factory.makeConstructor("appl", 2);
            this.amb = factory.makeConstructor("amb", 1);
            this.location = factory.makeConstructor("Location", 4);
        }

        private boolean isTreeChar(IStrategoTerm t) {
            return t.getTermType() == 3;
        }

        private boolean isTreeAppl(IStrategoTerm t) {
            return t.getTermType() == 1 && ((IStrategoAppl)t).getConstructor() == this.appl;
        }

        private boolean isTreeLayout(IStrategoTerm t) {
            return t.getTermType() == 1 && Tools.termAt(Tools.termAt(t, 0), 1).equals(this.layout);
        }

        private IStrategoAppl makeTreeAppl(IStrategoTerm prod, IStrategoList args) {
            return this.factory.makeAppl(this.appl, prod, args);
        }

        private boolean isTreeAmb(IStrategoTerm t) {
            return t.getTermType() == 1 && ((IStrategoAppl)t).getConstructor() == this.amb;
        }

        private IStrategoTerm makeTreeAmb(IStrategoTerm[] ts) {
            return this.factory.makeAppl(this.amb, this.factory.makeList(ts));
        }

        private int getTreeChar(IStrategoTerm tree) {
            return Tools.asJavaInt(tree);
        }

        private IStrategoTerm setLocation(IStrategoTerm t, int firstLine, int firstColumn, int lastLine, int lastColumn) {
            IStrategoList annos = t.getAnnotations();
            assert (annos != null);
            IStrategoAppl anno = this.factory.makeAppl(this.location, this.factory.makeInt(firstLine), this.factory.makeInt(firstColumn), this.factory.makeInt(lastLine), this.factory.makeInt(lastColumn));
            annos = this.factory.makeListCons(anno, annos);
            return this.factory.annotateTerm(t, annos);
        }

        private void scan(IStrategoTerm t) {
            if (this.isTreeChar(t)) {
                if (this.getTreeChar(t) == 10) {
                    this.column = 1;
                    ++this.line;
                } else {
                    ++this.column;
                }
            } else if (this.isTreeAppl(t)) {
                IStrategoList args = (IStrategoList)Tools.termAt(t, 1);
                while (!args.isEmpty()) {
                    this.scan(args.head());
                    args = args.tail();
                }
            } else if (this.isTreeAmb(t)) {
                this.scan((IStrategoTerm)Tools.termAt(Tools.termAt(t, 0), 0));
            } else {
                System.err.println("STRSGLR_anno_location: unhandled tree - " + t);
            }
        }

        private IStrategoList traverseArgs(IStrategoList args) {
            if (args.isEmpty()) {
                return args;
            }
            IStrategoTerm arg = this.traverse(args.head());
            return this.factory.makeListCons(arg, this.traverseArgs(args.tail()));
        }

        public IStrategoTerm traverse(IStrategoTerm t) {
            int firstLine = this.line++;
            int firstColumn = this.column++;
            if (this.isTreeChar(t)) {
                if (this.getTreeChar(t) == 10) {
                    this.column = 1;
                }
                return t;
            }
            if (this.isTreeLayout(t)) {
                this.scan(t);
                return t;
            }
            if (this.isTreeAppl(t)) {
                IStrategoList args = this.traverseArgs((IStrategoList)Tools.termAt(t, 1));
                t = this.makeTreeAppl((IStrategoTerm)Tools.termAt(t, 0), args);
            } else if (this.isTreeAmb(t)) {
                IStrategoList args = (IStrategoList)Tools.termAt(t, 0);
                LinkedList<IStrategoTerm> newArgs = new LinkedList<IStrategoTerm>();
                int line = this.line;
                int column = this.column;
                while (!args.isEmpty()) {
                    this.line = line;
                    this.column = column;
                    newArgs.addFirst(this.traverse(args.head()));
                    args = args.tail();
                }
                t = this.makeTreeAmb(newArgs.toArray(new IStrategoTerm[newArgs.size()]));
            } else {
                System.err.println("STRSGLR_anno_location: unhandled tree - " + t);
            }
            return this.setLocation(t, firstLine, firstColumn, this.line, this.column);
        }
    }
}

