/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.future;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.CheckedAction1;
import org.metaborg.util.functions.CheckedAction2;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.CheckedFunction2;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;
import org.metaborg.util.tuple.Tuple4;

public class AggregateFuture<T, R>
implements IFuture<R> {
    private static final ILogger logger = LoggerUtils.logger(AggregateFuture.class);
    private static final Function1 ID_REDUCER = v -> v;
    private Object lock = new Object();
    private volatile int remaining;
    private final T[] results;
    private final CompletableFuture<R> result;
    private final Function1<List<T>, R> reducer;

    @SafeVarargs
    private AggregateFuture(Function1<List<T>, R> reducer, IFuture<SC<T, R>> ... futures) {
        this(reducer, Arrays.asList(futures));
    }

    private AggregateFuture(Function1<List<T>, R> reducer, List<IFuture<SC<T, R>>> futures) {
        int count = futures.size();
        this.results = new Object[count];
        this.result = new CompletableFuture();
        this.reducer = reducer;
        logger.trace("{} initialized with {}: {}", this, count, futures);
        this.remaining = count;
        int i = 0;
        while (i < count) {
            int j = i;
            futures.get(i).whenComplete((? super T r, Throwable ex) -> this.whenComplete(j, (SC<? extends T, ? extends R>)r, (Throwable)ex));
            ++i;
        }
        this.fireIfComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whenComplete(int i, SC<? extends T, ? extends R> v, Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            if (this.remaining > 0) {
                if (ex != null) {
                    logger.trace("{} completed {}: exception", this, i);
                    this.remaining = -1;
                } else if (this.remaining > 0) {
                    v.visit(t -> {
                        logger.trace("{} completed {}: value", this, i);
                        --this.remaining;
                        this.results[n] = t;
                    }, r -> {
                        logger.trace("{} completed {}: short-circuit", this, i);
                        this.remaining = -1;
                        this.result.complete(r);
                    });
                }
            }
        }
        if (ex != null) {
            this.result.completeExceptionally(ex);
        } else {
            this.fireIfComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIfComplete() {
        List<T> results;
        Object object = this.lock;
        synchronized (object) {
            if (this.remaining == 0) {
                logger.trace("{} done: completed all", this);
                results = Arrays.asList(this.results);
            } else {
                logger.trace("{} open: {} remaining", this, this.remaining);
                results = null;
            }
        }
        if (results != null) {
            this.result.complete(this.reducer.apply(results));
        }
    }

    @Override
    public <U> IFuture<U> handle(CheckedFunction2<? super R, Throwable, ? extends U, ? extends Throwable> handler) {
        return this.result.handle(handler);
    }

    @Override
    public IFuture<R> whenComplete(CheckedAction2<? super R, Throwable, ? extends Throwable> handler) {
        return this.result.whenComplete(handler);
    }

    @Override
    public <U> IFuture<U> thenApply(CheckedFunction1<? super R, ? extends U, ? extends Throwable> handler) {
        return this.result.thenApply(handler);
    }

    @Override
    public IFuture<Void> thenAccept(CheckedAction1<? super R, ? extends Throwable> handler) {
        return this.result.thenAccept(handler);
    }

    @Override
    public <U> IFuture<U> thenCompose(CheckedFunction1<? super R, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        return this.result.thenCompose(handler);
    }

    @Override
    public <U> IFuture<U> compose(CheckedFunction2<? super R, Throwable, ? extends IFuture<? extends U>, ? extends Throwable> handler) {
        return this.result.compose(handler);
    }

    @Override
    public boolean isDone() {
        return this.result.isDone();
    }

    @Override
    public java.util.concurrent.CompletableFuture<R> asJavaCompletion() {
        return this.result.asJavaCompletion();
    }

    @SafeVarargs
    public static <T> IFuture<List<T>> of(IFuture<? extends T> ... futures) {
        return AggregateFuture.of(Arrays.asList(futures));
    }

    public static <T> IFuture<List<T>> of(Iterable<? extends IFuture<? extends T>> futures) {
        ArrayList mappedFutures = new ArrayList();
        futures.forEach(future -> {
            boolean bl = mappedFutures.add(future.thenApply(SC::of));
        });
        return new AggregateFuture(ID_REDUCER, mappedFutures);
    }

    @SafeVarargs
    public static <T, R> IFuture<R> ofShortCircuitable(Function1<List<T>, R> reduce, IFuture<SC<T, R>> ... futures) {
        return new AggregateFuture<T, R>(reduce, Arrays.asList(futures));
    }

    public static <T, R> IFuture<R> ofShortCircuitable(Function1<List<T>, R> reduce, List<IFuture<SC<T, R>>> futures) {
        return new AggregateFuture<T, R>(reduce, futures);
    }

    public static <T1, T2> IFuture<Tuple2<T1, T2>> apply(IFuture<T1> f1, IFuture<T2> f2) {
        return AggregateFuture.of(f1, f2).thenApply((? super T rs) -> Tuple2.of(rs.get(0), rs.get(1)));
    }

    public static <T1, T2, T3> IFuture<Tuple3<T1, T2, T3>> apply(IFuture<T1> f1, IFuture<T2> f2, IFuture<T3> f3) {
        return AggregateFuture.of(f1, f2, f3).thenApply((? super T rs) -> Tuple3.of(rs.get(0), rs.get(1), rs.get(2)));
    }

    public static <T1, T2, T3, T4> IFuture<Tuple4<T1, T2, T3, T4>> apply(IFuture<T1> f1, IFuture<T2> f2, IFuture<T3> f3, IFuture<T4> f4) {
        return AggregateFuture.of(f1, f2, f3, f4).thenApply((? super T rs) -> Tuple4.of(rs.get(0), rs.get(1), rs.get(2), rs.get(3)));
    }

    public static <T, U> IFuture<List<U>> forAll(Collection<T> items, Function1<T, IFuture<U>> toFuture) {
        if (items.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList futures = new ArrayList();
        items.forEach(item -> {
            boolean bl = futures.add((IFuture)toFuture.apply(item));
        });
        if (futures.size() == 1) {
            return ((IFuture)futures.get(0)).thenApply(Collections::singletonList);
        }
        return AggregateFuture.of(futures);
    }

    private static final class DoSC<T, R>
    implements SC<T, R> {
        private final R result;

        public DoSC(R result) {
            this.result = result;
        }

        @Override
        public void visit(Action1<T> onNoSC, Action1<R> onSC) {
            onSC.apply(this.result);
        }
    }

    private static final class NoSC<T, R>
    implements SC<T, R> {
        private final T result;

        public NoSC(T result) {
            this.result = result;
        }

        @Override
        public void visit(Action1<T> onNoSC, Action1<R> onSC) {
            onNoSC.apply(this.result);
        }
    }

    public static interface SC<T, R> {
        public void visit(Action1<T> var1, Action1<R> var2);

        public static <T, R> SC<T, R> shortCircuit(R result) {
            return new DoSC(result);
        }

        public static <T, R> SC<T, R> of(T result) {
            return new NoSC(result);
        }
    }
}

