/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.metaborg.util.collection.Multimap;

public class SetMultimap<K, V>
extends Multimap<K, V, Set<V>>
implements Serializable {
    public static final long serialVersionUID = 1L;

    public SetMultimap() {
    }

    public SetMultimap(SetMultimap<K, V> toCopy) {
        super(toCopy);
    }

    @Override
    protected Set<V> newCollection() {
        return new HashSet();
    }

    @Override
    protected Set<V> emptyCollection() {
        return Collections.emptySet();
    }

    @Override
    protected Set<V> unmodifiableCollection(Set<V> collection) {
        return Collections.unmodifiableSet(collection);
    }

    @Override
    protected Set<V> copyCollection(Set<V> collection) {
        return new HashSet<V>(collection);
    }

    public boolean remove(K key, V value) {
        Set values = (Set)this.backingMap.getOrDefault(key, this.emptyCollection());
        boolean removed = values.remove(value);
        if (removed && values.isEmpty()) {
            this.backingMap.remove(key);
        }
        return removed;
    }

    public Set<V> remove(K key) {
        Set remove = (Set)this.backingMap.remove(key);
        if (remove != null) {
            Set<V> copyToReturn = this.copyCollection(remove);
            remove.clear();
            return copyToReturn;
        }
        return Collections.emptySet();
    }

    public Set<V> replaceValues(K key, Set<V> values) {
        if (values.isEmpty()) {
            return this.remove(key);
        }
        return this.backingMap.replace(key, this.copyCollection(values));
    }

    public static <K, V> Collector<Map.Entry<K, V>, SetMultimap<K, V>, SetMultimap<K, V>> collector() {
        return new Collector<Map.Entry<K, V>, SetMultimap<K, V>, SetMultimap<K, V>>(){

            @Override
            public Supplier<SetMultimap<K, V>> supplier() {
                return SetMultimap::new;
            }

            @Override
            public BiConsumer<SetMultimap<K, V>, Map.Entry<K, V>> accumulator() {
                return (m, e) -> {
                    boolean bl = m.put(e.getKey(), e.getValue());
                };
            }

            @Override
            public BinaryOperator<SetMultimap<K, V>> combiner() {
                return (m1, m2) -> {
                    m1.putAll(m2);
                    return m1;
                };
            }

            @Override
            public Function<SetMultimap<K, V>, SetMultimap<K, V>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }
}

