/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.unit;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.unit.IUnit;
import org.metaborg.core.unit.IUnitContrib;

public class Unit
implements IUnit {
    @Nullable
    private final FileObject source;
    private final Map<String, IUnitContrib> contribs;

    public Unit(@Nullable FileObject source, Map<String, IUnitContrib> contribs) {
        this.contribs = contribs;
        this.source = source;
    }

    public Unit(@Nullable FileObject source) {
        this(source, new HashMap<String, IUnitContrib>());
    }

    public Unit() {
        this(null);
    }

    @Override
    public boolean detached() {
        return this.source == null;
    }

    @Override
    @Nullable
    public FileObject source() {
        return this.source;
    }

    @Override
    @Nullable
    public IUnitContrib unitContrib(String id) {
        return this.contribs.get(id);
    }

    @Override
    public Iterable<IUnitContrib> unitContribs() {
        return this.contribs.values();
    }

    public void addUnitContrib(IUnitContrib contrib) {
        this.contribs.put(contrib.id(), contrib);
    }
}

