/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.transform;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.action.ITransformAction;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.context.IContext;
import org.metaborg.core.editor.IEditorRegistry;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.transform.ITransformConfig;
import org.metaborg.core.transform.TransformException;
import org.metaborg.core.unit.IUnit;
import org.metaborg.spoofax.core.action.TransformAction;
import org.metaborg.spoofax.core.dynamicclassloading.BuilderInput;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.transform.IStrategoTransformer;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxTransformUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.spoofax.core.unit.TransformContrib;
import org.metaborg.spoofax.core.unit.TransformOutput;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class StrategoTransformer
implements IStrategoTransformer {
    private static final ILogger logger = LoggerUtils.logger(StrategoTransformer.class);
    private final IResourceService resourceService;
    private final ISpoofaxUnitService unitService;
    private final IEditorRegistry editorRegistry;
    private final ISpoofaxTracingService tracingService;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final IStrategoCommon common;

    @Inject
    public StrategoTransformer(IResourceService resourceService, ISpoofaxUnitService unitService, IEditorRegistry editorRegistry, ISpoofaxTracingService tracingService, IStrategoRuntimeService strategoRuntimeService, IStrategoCommon common) {
        this.resourceService = resourceService;
        this.unitService = unitService;
        this.editorRegistry = editorRegistry;
        this.tracingService = tracingService;
        this.strategoRuntimeService = strategoRuntimeService;
        this.common = common;
    }

    @Override
    public ISpoofaxTransformUnit<ISpoofaxParseUnit> transform(ISpoofaxParseUnit input, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform parse unit " + input + ", it is not valid");
        }
        return this.transform(input, context, action, input.source(), input.ast(), config);
    }

    @Override
    public ISpoofaxTransformUnit<ISpoofaxAnalyzeUnit> transform(ISpoofaxAnalyzeUnit input, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform analyze unit " + input + ", it is not valid");
        }
        if (!input.hasAst()) {
            throw new TransformException("Cannot transform analyze unit " + input + ", it has no AST");
        }
        return this.transform(input, context, action, input.source(), input.ast(), config);
    }

    @Override
    public Collection<ISpoofaxTransformUnit<ISpoofaxParseUnit>> transformAllParsed(Iterable<ISpoofaxParseUnit> inputs, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        int size = Iterables2.size(inputs);
        ArrayList<ISpoofaxTransformUnit<ISpoofaxParseUnit>> transformUnits = new ArrayList<ISpoofaxTransformUnit<ISpoofaxParseUnit>>(size);
        for (ISpoofaxParseUnit input : inputs) {
            if (!input.valid()) {
                throw new TransformException("Cannot transform parse unit " + input + ", it is not valid");
            }
            transformUnits.add(this.transform(input, context, action, input.source(), input.ast(), config));
        }
        return transformUnits;
    }

    @Override
    public Collection<ISpoofaxTransformUnit<ISpoofaxAnalyzeUnit>> transformAllAnalyzed(Iterable<ISpoofaxAnalyzeUnit> inputs, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        int size = Iterables2.size(inputs);
        ArrayList<ISpoofaxTransformUnit<ISpoofaxAnalyzeUnit>> transformUnits = new ArrayList<ISpoofaxTransformUnit<ISpoofaxAnalyzeUnit>>(size);
        for (ISpoofaxAnalyzeUnit input : inputs) {
            if (!input.valid()) {
                throw new TransformException("Cannot transform analyze unit " + input + ", it is not valid");
            }
            if (!input.hasAst()) {
                throw new TransformException("Cannot transform analyze unit " + input + ", it has no AST");
            }
            transformUnits.add(this.transform(input, context, action, input.source(), input.ast(), config));
        }
        return transformUnits;
    }

    private <I extends IUnit> ISpoofaxTransformUnit<I> transform(I input, IContext context, TransformActionContrib actionContribution, FileObject source, IStrategoTerm term, ITransformConfig config) throws TransformException {
        List<TransformOutput> outputs;
        IStrategoTerm resultTerm;
        long duration;
        TransformAction action;
        block16: {
            IStrategoTerm outputTerm;
            HybridInterpreter runtime;
            Iterable<IStrategoTerm> terms;
            Iterator<IStrategoTerm> termsIterator;
            FileObject location = context.location();
            ILanguageComponent component = actionContribution.contributor;
            action = this.action(actionContribution.action);
            ISourceRegion selection = config.selection();
            IStrategoTerm selectedTerm = selection != null ? ((termsIterator = (terms = this.tracingService.toTermsWithin(term, selection)).iterator()).hasNext() ? termsIterator.next() : null) : null;
            BuilderInput inputTerm = this.common.builderInputTerm(term, selectedTerm, source, location);
            try {
                runtime = this.strategoRuntimeService.runtime(component, context);
            }
            catch (MetaborgException e) {
                throw new TransformException("Transformation failed unexpectedly; cannot get Stratego interpreter", e);
            }
            logger.debug("Transforming {} with '{}'", source, action.name);
            Timer timer = new Timer(true);
            try {
                outputTerm = this.common.invoke(runtime, inputTerm, action.strategy);
            }
            catch (MetaborgException e) {
                throw new TransformException(e.getMessage(), e.getCause());
            }
            duration = timer.stop();
            if (outputTerm == null) {
                String message = logger.format("Invoking Stratego strategy {} failed", action.strategy);
                throw new TransformException(message);
            }
            if (outputTerm.getSubtermCount() == 2 && TermUtils.isTuple(outputTerm)) {
                IStrategoTerm resourceTerm = outputTerm.getSubterm(0);
                IStrategoTerm contentTerm = outputTerm.getSubterm(1);
                try {
                    if (TermUtils.isString(resourceTerm)) {
                        resultTerm = contentTerm;
                        outputs = Arrays.asList(this.output(resourceTerm, contentTerm, location, config));
                        break block16;
                    }
                    if (TermUtils.isList(resourceTerm)) {
                        if (!TermUtils.isList(contentTerm) || resourceTerm.getSubtermCount() != contentTerm.getSubtermCount()) {
                            logger.error("List of terms does not match list of file names, cannot write to file.");
                            resultTerm = null;
                            outputs = Collections.emptyList();
                        } else {
                            outputs = new ArrayList<TransformOutput>(resourceTerm.getSubtermCount());
                            int i = 0;
                            while (i < resourceTerm.getSubtermCount()) {
                                outputs.add(this.output(resourceTerm.getSubterm(i), contentTerm.getSubterm(i), location, config));
                                ++i;
                            }
                            resultTerm = resourceTerm.getSubtermCount() == 1 ? resourceTerm.getSubterm(0) : null;
                        }
                        break block16;
                    }
                    logger.error("First term of result tuple {} is neither a string, nor a list, cannot write output file", resourceTerm);
                    resultTerm = null;
                    outputs = Collections.emptyList();
                }
                catch (MetaborgException ex) {
                    logger.error("Failed to output result", ex);
                    resultTerm = null;
                    outputs = Collections.emptyList();
                }
            } else {
                resultTerm = outputTerm;
                outputs = Collections.emptyList();
            }
        }
        if (action.flags.openEditor) {
            ArrayList<FileObject> resources = new ArrayList<FileObject>(outputs.size());
            for (TransformOutput output : outputs) {
                if (output.resource == null) continue;
                resources.add(output.resource);
            }
            this.editorRegistry.open(resources, context.project());
        }
        TransformContrib contrib = new TransformContrib(resultTerm != null || !Iterables2.isEmpty(outputs), true, resultTerm, outputs, Iterables2.empty(), duration);
        return this.unitService.transformUnit(input, contrib, context, actionContribution);
    }

    private TransformAction action(ITransformAction action) throws TransformException {
        if (!(action instanceof TransformAction)) {
            String message = logger.format("Action {} is not a Stratego transformation action", action);
            throw new TransformException(message);
        }
        return (TransformAction)action;
    }

    private TransformOutput output(IStrategoTerm resourceTerm, IStrategoTerm contentTerm, FileObject location, ITransformConfig config) throws MetaborgException {
        FileObject output;
        if (!TermUtils.isString(resourceTerm)) {
            throw new MetaborgException("First term of result tuple {} is not a string, cannot write output file");
        }
        String resourceString = TermUtils.toJavaString(resourceTerm);
        if (!config.dryRun()) {
            String resultContents = this.common.toString(contentTerm);
            output = this.resourceService.resolve(location, resourceString);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (OutputStream stream = output.getContent().getOutputStream();){
                    IOUtils.write((String)resultContents, (OutputStream)stream, (Charset)Charset.defaultCharset());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("Error occurred while writing output file", e);
            }
        } else {
            output = null;
        }
        return new TransformOutput(resourceString, output, contentTerm);
    }
}

