/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import jakarta.annotation.Nullable;
import java.util.LinkedList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.syntax.FenceCharacters;
import org.metaborg.core.syntax.MultiLineCommentCharacters;
import org.metaborg.spoofax.core.syntax.ImploderImplementation;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class SyntaxFacet
implements IFacet {
    private static final ILogger logger = LoggerUtils.logger(SyntaxFacet.class);
    @Nullable
    public final FileObject parseTable;
    public final FileObject completionParseTable;
    public final Iterable<String> startSymbols;
    public final Iterable<String> singleLineCommentPrefixes;
    public final Iterable<MultiLineCommentCharacters> multiLineCommentCharacters;
    public final Iterable<FenceCharacters> fenceCharacters;
    public final ImploderImplementation imploder;

    public SyntaxFacet(@Nullable FileObject parseTable, FileObject completionParseTable, Iterable<String> startSymbols) {
        this(parseTable, completionParseTable, startSymbols, Iterables2.empty(), Iterables2.empty(), Iterables2.empty(), ImploderImplementation.java);
    }

    public SyntaxFacet(@Nullable FileObject parseTable, FileObject completionParseTable, Iterable<String> startSymbols, Iterable<String> singleLineCommentPrefixes, Iterable<MultiLineCommentCharacters> multiLineCommentCharacters, Iterable<FenceCharacters> fenceCharacters, ImploderImplementation imploder) {
        this.parseTable = parseTable;
        this.completionParseTable = completionParseTable;
        this.startSymbols = startSymbols;
        this.singleLineCommentPrefixes = singleLineCommentPrefixes;
        this.multiLineCommentCharacters = multiLineCommentCharacters;
        this.fenceCharacters = fenceCharacters;
        this.imploder = imploder;
    }

    public SyntaxFacet withImploderSetting(ImploderImplementation imploder) {
        return new SyntaxFacet(this.parseTable, this.completionParseTable, this.startSymbols, this.singleLineCommentPrefixes, this.multiLineCommentCharacters, this.fenceCharacters, imploder);
    }

    public Iterable<String> available() throws FileSystemException {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.parseTable != null && !this.parseTable.exists()) {
            String message = logger.format("SDF parse table file {} does not exist", this.parseTable);
            errors.add(message);
        }
        return errors;
    }
}

