/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.style;

import java.util.LinkedList;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokens;
import mb.jsglr.shared.ImploderAttachment;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.style.ICategory;
import org.metaborg.core.style.IRegionCategory;
import org.metaborg.core.style.RegionCategory;
import org.metaborg.spoofax.core.style.ConsCategory;
import org.metaborg.spoofax.core.style.ISpoofaxCategorizerService;
import org.metaborg.spoofax.core.style.SortCategory;
import org.metaborg.spoofax.core.style.SortConsCategory;
import org.metaborg.spoofax.core.style.StylerFacet;
import org.metaborg.spoofax.core.style.TokenCategory;
import org.metaborg.spoofax.core.syntax.JSGLRSourceRegionFactory;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.ParentAttachment;
import org.spoofax.terms.util.TermUtils;

public class CategorizerService
implements ISpoofaxCategorizerService {
    private static final ILogger logger = LoggerUtils.logger(CategorizerService.class);

    @Override
    public Iterable<IRegionCategory<IStrategoTerm>> categorize(ILanguageImpl language, ISpoofaxParseUnit parseResult) {
        LinkedList<IRegionCategory<IStrategoTerm>> regionCategories = new LinkedList<IRegionCategory<IStrategoTerm>>();
        if (!parseResult.valid()) {
            return regionCategories;
        }
        StylerFacet facet = language.facet(StylerFacet.class);
        if (facet == null) {
            logger.error("Cannot categorize input of {}, it does not have a styler facet", language);
            return regionCategories;
        }
        ImploderAttachment rootImploderAttachment = ImploderAttachment.get(parseResult.ast());
        if (rootImploderAttachment == null) {
            logger.error("Cannot categorize input {} of {}, it does not have an imploder attachment", parseResult, language);
            return regionCategories;
        }
        ITokens tokenizer = rootImploderAttachment.getLeftToken().getTokenizer();
        if (tokenizer == null) {
            logger.error("Cannot categorize input {} of {}, it does not have a tokenizer", parseResult, language);
            return regionCategories;
        }
        for (IToken token : tokenizer) {
            ICategory category = this.category(facet, token);
            if (category == null) continue;
            ISourceRegion region = JSGLRSourceRegionFactory.fromToken(token);
            IStrategoTerm term = (IStrategoTerm)token.getAstNode();
            regionCategories.add(new RegionCategory<IStrategoTerm>(region, category, term));
        }
        return regionCategories;
    }

    @Override
    public Iterable<IRegionCategory<IStrategoTerm>> categorize(ILanguageImpl language, ISpoofaxAnalyzeUnit analysisResult) {
        throw new UnsupportedOperationException();
    }

    private ICategory category(StylerFacet facet, IToken token) {
        ICategory category;
        IStrategoTerm parentTerm;
        IStrategoTerm term = (IStrategoTerm)token.getAstNode();
        if (term == null) {
            return this.tokenCategory(token);
        }
        if (!(TermUtils.isAppl(term) || TermUtils.isTuple(term) || TermUtils.isList(term) || (parentTerm = ParentAttachment.getParent(term)) == null || (category = this.sortConsCategory(facet, parentTerm)) == null)) {
            return category;
        }
        ICategory category2 = this.sortConsCategory(facet, term);
        if (category2 != null) {
            return category2;
        }
        return this.tokenCategory(token);
    }

    private ICategory sortConsCategory(StylerFacet facet, IStrategoTerm term) {
        ImploderAttachment imploderAttachment = ImploderAttachment.get(term);
        String sort = imploderAttachment.getSort();
        if (sort == null) {
            return null;
        }
        String massagedSort = sort.replace("_sort", "");
        if (TermUtils.isAppl(term)) {
            String cons = ((IStrategoAppl)term).getConstructor().getName();
            if (facet.hasSortConsStyle(massagedSort, cons)) {
                return new SortConsCategory(massagedSort, cons);
            }
            if (facet.hasConsStyle(cons)) {
                return new ConsCategory(cons);
            }
            if (facet.hasSortStyle(massagedSort)) {
                return new SortCategory(massagedSort);
            }
            return null;
        }
        if (facet.hasSortStyle(massagedSort)) {
            return new SortCategory(massagedSort);
        }
        return null;
    }

    private ICategory tokenCategory(IToken token) {
        switch (token.getKind()) {
            case TK_IDENTIFIER: {
                return new TokenCategory("TK_IDENTIFIER");
            }
            case TK_NUMBER: {
                return new TokenCategory("TK_NUMBER");
            }
            case TK_STRING: {
                return new TokenCategory("TK_STRING");
            }
            case TK_KEYWORD: 
            case TK_ERROR_KEYWORD: {
                return new TokenCategory("TK_KEYWORD");
            }
            case TK_OPERATOR: {
                return new TokenCategory("TK_OPERATOR");
            }
            case TK_VAR: {
                return new TokenCategory("TK_VAR");
            }
            case TK_LAYOUT: 
            case TK_ERROR_LAYOUT: {
                return new TokenCategory("TK_LAYOUT");
            }
            default: {
                logger.debug("Unhandled token kind " + (Object)((Object)token.getKind()));
            }
            case TK_UNKNOWN: 
            case TK_EOF: 
            case TK_ERROR: 
            case TK_ERROR_EOF_UNEXPECTED: 
            case TK_ESCAPE_OPERATOR: 
            case TK_RESERVED: 
            case TK_NO_TOKEN_KIND: 
        }
        return null;
    }
}

