/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.strategies;

import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.spoofax.core.syntax.ISpoofaxSyntaxService;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.Strategy;

public class ParseFileStrategy
extends Strategy {
    private final IResourceService resourceService;
    private final ILanguageIdentifierService languageIdentifierService;
    private final ISpoofaxUnitService unitService;
    private final ISourceTextService sourceTextService;
    private final ISpoofaxSyntaxService syntaxService;

    @Inject
    public ParseFileStrategy(IResourceService resourceService, ILanguageIdentifierService languageIdentifierService, ISpoofaxUnitService unitService, ISourceTextService sourceTextService, ISpoofaxSyntaxService syntaxService) {
        this.resourceService = resourceService;
        this.languageIdentifierService = languageIdentifierService;
        this.unitService = unitService;
        this.sourceTextService = sourceTextService;
        this.syntaxService = syntaxService;
    }

    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm current) {
        IdentifiedResource identifiedResource;
        FileObject resource;
        block6: {
            block5: {
                if (!TermUtils.isString(current)) {
                    return null;
                }
                String path = TermUtils.toJavaString(current);
                resource = this.resourceService.resolve(path);
                if (resource.getType() == FileType.FILE) break block5;
                return null;
            }
            identifiedResource = this.languageIdentifierService.identifyToResource(resource);
            if (identifiedResource != null) break block6;
            return null;
        }
        try {
            String text = this.sourceTextService.text(resource);
            ISpoofaxInputUnit input = (ISpoofaxInputUnit)this.unitService.inputUnit(resource, text, identifiedResource.language, identifiedResource.dialect);
            ISpoofaxParseUnit result = (ISpoofaxParseUnit)this.syntaxService.parse(input);
            return result.ast();
        }
        catch (IOException | ParseException e) {
            throw new StrategoException("Parsing failed unexpectedly", e);
        }
    }
}

