/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.AggregateMetaborgException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.spoofax.core.dynamicclassloading.BuilderInput;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.lang.Context;
import org.strategoxt.stratego_aterm.Main;
import org.strategoxt.stratego_aterm.aterm_escape_strings_0_0;
import org.strategoxt.stratego_aterm.pp_aterm_box_0_0;
import org.strategoxt.stratego_gpp.box2text_string_0_1;

public class StrategoCommon
implements IStrategoCommon {
    private static final ILogger logger = LoggerUtils.logger(StrategoCommon.class);
    private final IStrategoRuntimeService strategoRuntimeService;
    private final ITermFactory termFactory;

    @Inject
    public StrategoCommon(IStrategoRuntimeService strategoRuntimeService, ITermFactory termFactory) {
        this.strategoRuntimeService = strategoRuntimeService;
        this.termFactory = termFactory;
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(ILanguageComponent component, IContext context, IStrategoTerm input, String strategy) throws MetaborgException {
        if (!IStrategoCommon.hasStrategoFacets(component)) {
            return null;
        }
        HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, context);
        return this.invoke(runtime, input, strategy);
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(ILanguageImpl impl, IContext context, IStrategoTerm input, String strategy) throws MetaborgException {
        ArrayList<MetaborgException> exceptions = new ArrayList<MetaborgException>();
        for (ILanguageComponent component : impl.components()) {
            if (!IStrategoCommon.hasStrategoFacets(component)) continue;
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, context);
            try {
                IStrategoTerm result = this.invoke(runtime, input, strategy);
                return result;
            }
            catch (MetaborgException ex) {
                exceptions.add(ex);
            }
        }
        throw new AggregateMetaborgException(exceptions);
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(ILanguageImpl impl, IContext context, IStrategoTerm input, String strategy, List<IStrategoTerm> termArguments) throws MetaborgException {
        ArrayList<MetaborgException> exceptions = new ArrayList<MetaborgException>();
        for (ILanguageComponent component : impl.components()) {
            if (!IStrategoCommon.hasStrategoFacets(component)) continue;
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, context);
            try {
                IStrategoTerm result = this.invoke(runtime, input, strategy, termArguments);
                return result;
            }
            catch (MetaborgException ex) {
                exceptions.add(ex);
            }
        }
        throw new AggregateMetaborgException(exceptions);
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(ILanguageImpl impl, FileObject location, IStrategoTerm input, String strategy) throws MetaborgException {
        ArrayList<MetaborgException> exceptions = new ArrayList<MetaborgException>();
        for (ILanguageComponent component : impl.components()) {
            if (!IStrategoCommon.hasStrategoFacets(component)) continue;
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            try {
                IStrategoTerm result = this.invoke(runtime, input, strategy);
                return result;
            }
            catch (MetaborgException ex) {
                exceptions.add(ex);
            }
        }
        throw new AggregateMetaborgException(exceptions);
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(ILanguageImpl impl, FileObject location, IStrategoTerm input, String strategy, List<IStrategoTerm> termArguments) throws MetaborgException {
        ArrayList<MetaborgException> exceptions = new ArrayList<MetaborgException>();
        for (ILanguageComponent component : impl.components()) {
            if (!IStrategoCommon.hasStrategoFacets(component)) continue;
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            try {
                IStrategoTerm result = this.invoke(runtime, input, strategy, termArguments);
                return result;
            }
            catch (MetaborgException ex) {
                exceptions.add(ex);
            }
        }
        throw new AggregateMetaborgException(exceptions);
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(HybridInterpreter runtime, IStrategoTerm input, String strategy) throws MetaborgException {
        block3: {
            runtime.setCurrent(input);
            try {
                boolean success = runtime.invoke(strategy);
                if (success) break block3;
                return null;
            }
            catch (InterpreterException e) {
                throw this.handleException(e, runtime, strategy);
            }
        }
        return runtime.current();
    }

    @Override
    @Nullable
    public IStrategoTerm invoke(HybridInterpreter runtime, IStrategoTerm input, String strategy, List<IStrategoTerm> termArguments) throws MetaborgException {
        runtime.setCurrent(input);
        IStrategoString strategyName = this.createStrategyName(strategy, termArguments.size());
        IStrategoAppl strategyNameTerm = this.termFactory.makeAppl("SVar", strategyName);
        IStrategoAppl strategyCallTerm = this.termFactory.makeAppl("CallT", strategyNameTerm, this.termFactory.makeList(), this.termFactory.makeList(termArguments));
        try {
            if (runtime.evaluate(strategyCallTerm)) {
                return runtime.current();
            }
        }
        catch (InterpreterException e) {
            throw this.handleException(e, runtime, strategy);
        }
        return null;
    }

    private IStrategoString createStrategyName(String identifier, int termArgSize) {
        String strategyName = String.valueOf(Interpreter.cify(identifier)) + "_0_" + termArgSize;
        IStrategoString strategyNameTerm = this.termFactory.makeString(strategyName);
        return strategyNameTerm;
    }

    private MetaborgException handleException(InterpreterException ex, HybridInterpreter runtime, String strategy) {
        String trace = this.traceToString(runtime.getCompiledContext().getTrace());
        try {
            throw ex;
        }
        catch (InterpreterErrorExit e) {
            String message;
            String innerTrace;
            IStrategoTerm term = e.getTerm();
            String string = innerTrace = e.getTrace() != null ? this.traceToString(e.getTrace()) : trace;
            if (term != null) {
                IStrategoString ppTerm = this.prettyPrint(term);
                String termString = ppTerm != null ? ppTerm.stringValue() : term.toString();
                message = logger.format("Invoking Stratego strategy {} failed at term:\n\t{}\n{}\n{}", strategy, termString, innerTrace, e.getMessage());
            } else {
                message = logger.format("Invoking Stratego strategy {} failed.\n{}\n{}", strategy, innerTrace, e.getMessage());
            }
            return new MetaborgException(message, e);
        }
        catch (InterpreterExit e) {
            String message = logger.format("Invoking Stratego strategy {} failed with exit code {}\n{}\n{}", strategy, e.getValue(), trace, e.getMessage());
            return new MetaborgException(message, e);
        }
        catch (UndefinedStrategyException e) {
            String message = logger.format("Invoking Stratego strategy {} failed, strategy is undefined\n{}\n{}", strategy, trace, e.getMessage());
            return new MetaborgException(message, e);
        }
        catch (InterpreterException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InterpreterException) {
                return this.handleException((InterpreterException)cause, runtime, strategy);
            }
            String message = logger.format("Invoking Stratego strategy {} failed unexpectedly\n{}\n{}", strategy, trace, e.getMessage());
            return new MetaborgException(message, e);
        }
    }

    private String traceToString(String[] trace) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stratego trace:");
        int depth = trace.length;
        int i = 0;
        while (i < depth) {
            sb.append("\n\t");
            sb.append(trace[depth - i - 1]);
            ++i;
        }
        return sb.toString();
    }

    private String traceToString(IStrategoList trace) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stratego trace:");
        int depth = trace.getSubtermCount();
        int i = 0;
        while (i < depth) {
            IStrategoTerm t = trace.getSubterm(depth - i - 1);
            sb.append("\n\t");
            sb.append(TermUtils.isString(t) ? TermUtils.toJavaString(t) : t);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public IStrategoString locationTerm(FileObject location) {
        String locationURI = location.getName().getURI();
        IStrategoString locationTerm = this.termFactory.makeString(locationURI);
        return locationTerm;
    }

    @Override
    public IStrategoString resourceTerm(FileObject resource, FileObject location) {
        String resourceURI = ResourceUtils.relativeName(resource.getName(), location.getName(), false);
        IStrategoString resourceTerm = this.termFactory.makeString(resourceURI);
        return resourceTerm;
    }

    @Override
    public BuilderInput builderInputTerm(IStrategoTerm ast, @Nullable IStrategoTerm selectedTerm, @Nullable FileObject resource, @Nullable FileObject location) {
        IStrategoTerm node = selectedTerm != null ? selectedTerm : ast;
        IStrategoList position = this.termFactory.makeList();
        return new BuilderInput(this.termFactory, node, position, ast, resource, location);
    }

    @Override
    public String toString(IStrategoTerm term) {
        if (TermUtils.isString(term)) {
            return ((IStrategoString)term).stringValue();
        }
        IStrategoString pp = this.prettyPrint(term);
        if (pp != null) {
            return pp.stringValue();
        }
        logger.error("Could not pretty print ATerm, falling back to non-pretty printed ATerm");
        return term.toString();
    }

    @Override
    public IStrategoString prettyPrint(IStrategoTerm term) {
        Context context = this.strategoRuntimeService.genericRuntime().getCompiledContext();
        Main.init(context);
        term = aterm_escape_strings_0_0.instance.invoke(context, term);
        term = pp_aterm_box_0_0.instance.invoke(context, term);
        term = box2text_string_0_1.instance.invoke(context, term, this.termFactory.makeInt(120));
        return (IStrategoString)term;
    }
}

