/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.language.IComponentCreationConfigRequest;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacet;
import org.metaborg.spoofax.core.stratego.StrategoRuntimeFacet;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.interpreter.terms.IStrategoAppl;

public class ComponentFactoryRequest
implements IComponentCreationConfigRequest {
    private final boolean available;
    private final FileObject location;
    private final Collection<String> errors;
    private final Collection<Throwable> exceptions;
    @Nullable
    private final ILanguageComponentConfig config;
    @Nullable
    private final IStrategoAppl esvTerm;
    @Nullable
    private final SyntaxFacet syntaxFacet;
    @Nullable
    private final DynamicClassLoadingFacet dynamicClassLoadingFacet;
    @Nullable
    private final StrategoRuntimeFacet strategoRuntimeFacet;

    public ComponentFactoryRequest(FileObject location, @Nullable ILanguageComponentConfig config, @Nullable IStrategoAppl esvTerm, @Nullable SyntaxFacet syntaxFacet, @Nullable DynamicClassLoadingFacet dynamicClassLoadingFacet, @Nullable StrategoRuntimeFacet strategoRuntimeFacet) {
        this.available = true;
        this.location = location;
        this.errors = Collections.emptyList();
        this.exceptions = Collections.emptyList();
        this.esvTerm = esvTerm;
        this.config = config;
        this.syntaxFacet = syntaxFacet;
        this.dynamicClassLoadingFacet = dynamicClassLoadingFacet;
        this.strategoRuntimeFacet = strategoRuntimeFacet;
    }

    public ComponentFactoryRequest(FileObject location, Collection<String> errors, Collection<Throwable> exceptions) {
        this.available = false;
        this.location = location;
        this.errors = errors != null ? errors : Collections.emptyList();
        this.exceptions = exceptions != null ? exceptions : Collections.emptyList();
        this.esvTerm = null;
        this.config = null;
        this.syntaxFacet = null;
        this.dynamicClassLoadingFacet = null;
        this.strategoRuntimeFacet = null;
    }

    public ComponentFactoryRequest(FileObject location, Collection<String> errors) {
        this(location, errors, null);
    }

    public ComponentFactoryRequest(FileObject location, String error) {
        this(location, Collections.singletonList(error), null);
    }

    public ComponentFactoryRequest(FileObject location, Throwable exception) {
        this(location, null, Collections.singletonList(exception));
    }

    @Override
    public boolean valid() {
        return this.available;
    }

    @Override
    public FileObject location() {
        return this.location;
    }

    @Override
    @Nullable
    public ILanguageComponentConfig config() {
        return this.config;
    }

    @Override
    public Collection<String> errors() {
        return this.errors;
    }

    @Override
    public Collection<Throwable> exceptions() {
        return this.exceptions;
    }

    @Nullable
    public IStrategoAppl esvTerm() {
        return this.esvTerm;
    }

    @Nullable
    public SyntaxFacet syntaxFacet() {
        return this.syntaxFacet;
    }

    @Nullable
    public DynamicClassLoadingFacet dynamicClassLoadingFacet() {
        return this.dynamicClassLoadingFacet;
    }

    @Nullable
    public StrategoRuntimeFacet strategoRuntimeFacet() {
        return this.strategoRuntimeFacet;
    }

    public String toString() {
        boolean hasExceptions;
        StringBuilder sb = new StringBuilder();
        if (this.available) {
            sb.append("Found language component at ");
            sb.append(this.location);
            if (this.config != null) {
                sb.append(": ");
                sb.append(this.config.identifier());
            } else {
                sb.append(".");
            }
            sb.append("\n");
        } else {
            sb.append("Cannot create language component at ");
            sb.append(this.location);
            sb.append(".\n");
        }
        boolean hasErrors = !Iterables2.isEmpty(this.errors);
        boolean bl = hasExceptions = !Iterables2.isEmpty(this.exceptions);
        if (hasErrors) {
            sb.append("The following errors occurred: \n");
            for (String error : this.errors) {
                sb.append("  ");
                sb.append(error);
                sb.append('\n');
            }
        }
        if (hasExceptions) {
            if (hasErrors) {
                sb.append('\n');
            }
            sb.append("The following exceptions occurred: \n");
            for (Throwable exception : this.exceptions) {
                sb.append("  ");
                sb.append(ExceptionUtils.getStackTrace((Throwable)exception));
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

