/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.context;

import com.google.inject.Injector;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mb.util.vfs2.file.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.build.CommonPaths;
import org.metaborg.core.context.ContextIdentifier;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextInternal;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.project.IProject;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.engine.TaskManager;
import org.metaborg.spoofax.core.context.IIndexTaskContext;
import org.metaborg.util.concurrent.ClosableLock;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.library.index.IIndex;
import org.spoofax.interpreter.library.index.IndexManager;
import org.spoofax.interpreter.terms.ITermFactory;

public class IndexTaskContext
implements IContext,
IContextInternal,
IIndexTaskContext {
    private static final ILogger logger = LoggerUtils.logger(IndexTaskContext.class);
    private final Injector injector;
    private final ITermFactory termFactory;
    private final ReadWriteLock lock;
    private final String persistentIdentifier;
    private final ContextIdentifier identifier;
    private IIndex index;
    private ITaskEngine taskEngine;

    public IndexTaskContext(Injector injector, ITermFactory termFactory, ContextIdentifier identifier) {
        this.injector = injector;
        this.termFactory = termFactory;
        this.lock = new ReentrantReadWriteLock(true);
        this.persistentIdentifier = FileUtils.sanitize(identifier.language.id().toString());
        this.identifier = identifier;
    }

    @Override
    public ContextIdentifier identifier() {
        return this.identifier;
    }

    @Override
    public FileObject location() {
        return this.identifier.location;
    }

    @Override
    public IProject project() {
        return this.identifier.project;
    }

    @Override
    public ILanguageImpl language() {
        return this.identifier.language;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    @Nullable
    public IIndex index() {
        return this.index;
    }

    @Override
    @Nullable
    public ITaskEngine taskEngine() {
        return this.taskEngine;
    }

    @Override
    public IClosableLock read() {
        if (this.index == null || this.taskEngine == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IClosableLock lock = this.writeLock();){
                if (this.index == null) {
                    this.index = this.loadIndex();
                }
                if (this.taskEngine == null) {
                    this.taskEngine = this.loadTaskEngine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.index.recover();
        this.taskEngine.recover();
        return this.readLock();
    }

    private IClosableLock readLock() {
        Lock readLock = this.lock.readLock();
        ClosableLock lock = new ClosableLock(readLock);
        return lock;
    }

    @Override
    public IClosableLock write() {
        IClosableLock lock = this.writeLock();
        if (this.index == null) {
            this.index = this.loadIndex();
        }
        if (this.taskEngine == null) {
            this.taskEngine = this.loadTaskEngine();
        }
        this.index.recover();
        this.taskEngine.recover();
        return lock;
    }

    private IClosableLock writeLock() {
        Lock writeLock = this.lock.writeLock();
        ClosableLock lock = new ClosableLock(writeLock);
        return lock;
    }

    @Override
    public void persist() throws IOException {
        if (this.index == null && this.taskEngine == null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.readLock();){
            if (this.index != null) {
                IndexManager.write(this.index, this.indexFile(), this.termFactory);
            }
            if (this.taskEngine != null) {
                TaskManager.write(this.taskEngine, this.taskEngineFile(), this.termFactory);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws FileSystemException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            if (this.index != null) {
                this.index.reset();
                this.index = null;
            }
            if (this.taskEngine != null) {
                this.taskEngine.reset();
                this.taskEngine = null;
            }
            FileObject indexFile = this.indexFile();
            indexFile.delete();
            FileObject taskEngineFile = this.taskEngineFile();
            taskEngineFile.delete();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void init() {
        if (this.index != null && this.taskEngine != null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            if (this.index == null) {
                this.index = this.initIndex();
            }
            if (this.taskEngine == null) {
                this.taskEngine = this.initTaskEngine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void load() {
        if (this.index != null && this.taskEngine != null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            if (this.index == null) {
                this.index = this.loadIndex();
            }
            if (this.taskEngine == null) {
                this.taskEngine = this.loadTaskEngine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void unload() {
        if (this.index == null && this.taskEngine == null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            this.index = null;
            this.taskEngine = null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FileObject indexFile() throws FileSystemException {
        CommonPaths paths = new CommonPaths(this.identifier.location);
        return paths.targetDir().resolveFile("analysis").resolveFile(this.persistentIdentifier).resolveFile("index");
    }

    private IIndex initIndex() {
        return IndexManager.create(this.termFactory);
    }

    private IIndex loadIndex() {
        try {
            FileObject indexFile = this.indexFile();
            if (indexFile.exists()) {
                try {
                    IIndex index = IndexManager.read(indexFile, this.termFactory);
                    return index;
                }
                catch (Exception e) {
                    logger.error("Loading index from {} failed, deleting that file and returning an empty index. Clean the project to reanalyze", e, indexFile);
                    this.deleteIndexFile(indexFile);
                }
            }
        }
        catch (FileSystemException e) {
            logger.error("Locating index file for {} failed, returning an empty index. Clean the project to reanalyze", e, this);
        }
        return this.initIndex();
    }

    private void deleteIndexFile(FileObject file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            logger.error("Deleting index file {} failed, please delete the file manually", e, file);
        }
    }

    private FileObject taskEngineFile() throws FileSystemException {
        CommonPaths paths = new CommonPaths(this.identifier.location);
        return paths.targetDir().resolveFile("analysis").resolveFile(this.persistentIdentifier).resolveFile("tasks");
    }

    private ITaskEngine initTaskEngine() {
        return TaskManager.create(this.termFactory);
    }

    private ITaskEngine loadTaskEngine() {
        try {
            FileObject taskEngineFile = this.taskEngineFile();
            if (taskEngineFile.exists()) {
                try {
                    ITaskEngine taskEngine = TaskManager.read(taskEngineFile, this.termFactory);
                    return taskEngine;
                }
                catch (Exception e) {
                    logger.error("Loading task engine from {} failed, deleting that file and returning an empty task engine. Clean the project to reanalyze", e, taskEngineFile);
                    this.deleteTaskEngineFile(taskEngineFile);
                }
            }
        }
        catch (FileSystemException e) {
            logger.error("Locating task engine file for {} failed, returning an empty task engine. Clean the project to reanalyze", e, this);
        }
        return this.initTaskEngine();
    }

    private void deleteTaskEngineFile(FileObject file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            logger.error("Deleting task engine file {} failed, please delete the file manually", e, file);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexTaskContext other = (IndexTaskContext)obj;
        return this.identifier.equals(other.identifier);
    }

    public String toString() {
        return String.format("context for %s, %s", this.identifier.location, this.identifier.language);
    }
}

