/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.completion;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokenizer;
import mb.jsglr.shared.ImploderAttachment;
import mb.jsglr.shared.ListImploderAttachment;
import mb.jsglr.shared.Token;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.completion.Completion;
import org.metaborg.core.completion.CompletionKind;
import org.metaborg.core.completion.ICompletion;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.source.ISourceLocation;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.source.SourceLocation;
import org.metaborg.core.source.SourceRegion;
import org.metaborg.spoofax.core.completion.ISpoofaxCompletionService;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.syntax.ISpoofaxSyntaxService;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.syntax.JSGLRSourceRegionFactory;
import org.metaborg.spoofax.core.syntax.SourceAttachment;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.util.iterators.Iterables2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.StrategoConstructor;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.attachments.ParentAttachment;
import org.spoofax.terms.util.TermUtils;
import org.spoofax.terms.visitor.AStrategoTermVisitor;
import org.spoofax.terms.visitor.StrategoTermVisitee;
import org.strategoxt.HybridInterpreter;

public class JSGLRCompletionService
implements ISpoofaxCompletionService {
    private static final Logger logger = LoggerFactory.getLogger(JSGLRCompletionService.class);
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final IStrategoCommon strategoCommon;
    private final IResourceService resourceService;
    private final ISpoofaxUnitService unitService;
    private final ISpoofaxSyntaxService syntaxService;

    @Inject
    public JSGLRCompletionService(ITermFactory termFactory, IStrategoRuntimeService strategoRuntimeService, IStrategoCommon strategoCommon, IResourceService resourceService, ISpoofaxUnitService unitService, ISpoofaxSyntaxService syntaxService) {
        this.termFactory = termFactory;
        this.strategoRuntimeService = strategoRuntimeService;
        this.strategoCommon = strategoCommon;
        this.resourceService = resourceService;
        this.unitService = unitService;
        this.syntaxService = syntaxService;
    }

    @Override
    public Iterable<ICompletion> get(int position, ISpoofaxParseUnit parseInput, boolean nested) throws MetaborgException {
        ISpoofaxParseUnit completionParseResult = null;
        if (!nested && !parseInput.success()) {
            JSGLRParserConfiguration config = new JSGLRParserConfiguration(true, true, true, 3000, position);
            ISpoofaxInputUnit input = parseInput.input();
            ISpoofaxInputUnit modifiedInput = this.unitService.inputUnit(input.source(), input.text(), input.langImpl(), input.dialect(), config);
            completionParseResult = (ISpoofaxParseUnit)this.syntaxService.parse(modifiedInput);
        }
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        String inputText = parseInput.input().text();
        if (inputText.trim().isEmpty()) {
            ILanguageImpl language = parseInput.input().langImpl();
            FileObject location = parseInput.source();
            Iterable<String> startSymbols = language.facet(SyntaxFacet.class).startSymbols;
            completions.addAll(this.completionEmptyProgram(startSymbols, inputText.length(), language, location));
            return completions;
        }
        if (completionParseResult != null && completionParseResult.ast() == null) {
            return completions;
        }
        Collection<IStrategoTerm> nestedCompletionTerms = this.getNestedCompletionTermsFromAST(completionParseResult);
        Collection<IStrategoTerm> completionTerms = this.getCompletionTermsFromAST(completionParseResult);
        boolean blankLineCompletion = this.isCompletionBlankLine(position, parseInput.input().text());
        if (!completionTerms.isEmpty()) {
            completions.addAll(this.completionErroneousPrograms(position, completionTerms, completionParseResult));
        }
        if (!nestedCompletionTerms.isEmpty()) {
            completions.addAll(this.completionErroneousProgramsNested(position, nestedCompletionTerms, completionParseResult));
        }
        if (completionTerms.isEmpty() && nestedCompletionTerms.isEmpty()) {
            completions.addAll(this.completionCorrectPrograms(position, blankLineCompletion, parseInput));
        }
        return completions;
    }

    public Collection<? extends ICompletion> completionEmptyProgram(Iterable<String> startSymbols, int endOffset, ILanguageImpl language, FileObject location) throws MetaborgException {
        LinkedList<Completion> completions = new LinkedList<Completion>();
        String languageName = language.belongsTo().name();
        for (ILanguageComponent component : language.components()) {
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            for (String startSymbol : startSymbols) {
                String placeholderName = String.valueOf(startSymbol) + "-Plhdr";
                IStrategoAppl placeholder = this.termFactory.makeAppl(this.termFactory.makeConstructor(placeholderName, 0), new IStrategoTerm[0]);
                IStrategoTuple input = this.termFactory.makeTuple(this.termFactory.makeString(startSymbol), placeholder);
                IStrategoTerm proposalsPlaceholder = this.strategoCommon.invoke(runtime, input, "get-proposals-empty-program-" + languageName);
                if (proposalsPlaceholder == null) {
                    logger.error("Getting proposals for {} failed", (Object)placeholder);
                    continue;
                }
                for (IStrategoTerm proposalTerm : proposalsPlaceholder) {
                    if (!TermUtils.isTuple(proposalTerm)) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    IStrategoTuple tuple = TermUtils.toTuple(proposalTerm);
                    if (tuple.getSubtermCount() != 2 || !TermUtils.isStringAt(tuple, 0) || !TermUtils.isStringAt(tuple, 1)) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    String name = TermUtils.toJavaStringAt(tuple, 0);
                    String text = TermUtils.toJavaStringAt(tuple, 1);
                    String additionalInfo = TermUtils.toJavaStringAt(tuple, 1);
                    completions.add(new Completion(name, startSymbol, text, additionalInfo, 0, endOffset, CompletionKind.expansion));
                }
            }
        }
        return completions;
    }

    private boolean isCompletionBlankLine(int position, String text) {
        int i;
        for (i = position - 1; i >= 0; --i) {
            if (text.charAt(i) == '\n') break;
            if (text.charAt(i) == ' ' || text.charAt(i) == '\t') {
                continue;
            }
            return false;
        }
        for (i = position; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') break;
            if (text.charAt(i) == ' ' || text.charAt(i) == '\t') {
                continue;
            }
            return false;
        }
        return true;
    }

    public Collection<ICompletion> completionCorrectPrograms(int position, boolean blankLineCompletion, ISpoofaxParseUnit parseResult) throws MetaborgException {
        HashSet<ICompletion> completions = new HashSet<ICompletion>();
        FileObject location = parseResult.source();
        ILanguageImpl language = parseResult.input().langImpl();
        String languageName = language.belongsTo().name();
        for (ILanguageComponent component : language.components()) {
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            HashMap<IStrategoTerm, Boolean> leftRecursiveTerms = new HashMap<IStrategoTerm, Boolean>();
            HashMap<IStrategoTerm, Boolean> rightRecursiveTerms = new HashMap<IStrategoTerm, Boolean>();
            Iterable<IStrategoTerm> terms = this.tracingTermsCompletions(position, parseResult.ast(), new SourceRegion(position), runtime, this.termFactory, languageName, leftRecursiveTerms, rightRecursiveTerms);
            IStrategoAppl placeholder = this.getPlaceholder(position, terms);
            Iterable<IStrategoList> lists = this.getLists(terms, leftRecursiveTerms, rightRecursiveTerms);
            Iterable<IStrategoTerm> optionals = this.getOptionals(terms, leftRecursiveTerms, rightRecursiveTerms);
            Iterable<IStrategoTerm> leftRecursive = this.getLeftRecursiveTerms(position, terms, leftRecursiveTerms);
            Iterable<IStrategoTerm> rightRecursive = this.getRightRecursiveTerms(position, terms, rightRecursiveTerms);
            if (placeholder != null) {
                completions.addAll(this.placeholderCompletions(placeholder, languageName, component, location));
                continue;
            }
            if (Iterables2.size(lists) != 0) {
                completions.addAll(this.listsCompletions(position, blankLineCompletion, lists, languageName, component, location));
            }
            if (Iterables2.size(optionals) == 0) continue;
            completions.addAll(this.optionalCompletions(optionals, blankLineCompletion, languageName, component, location));
        }
        return completions;
    }

    private Collection<? extends ICompletion> recursiveCompletions(Iterable<IStrategoTerm> leftRecursive, Iterable<IStrategoTerm> rightRecursive, String languageName, ILanguageComponent component, FileObject location) throws MetaborgException {
        ICompletion completion;
        IStrategoAppl change;
        String additionalInfo;
        String text;
        String name;
        IStrategoTuple tuple;
        IStrategoTerm proposals;
        IStrategoTuple strategoInput;
        IStrategoString sort;
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
        for (IStrategoTerm term : leftRecursive) {
            sort = this.termFactory.makeString(ImploderAttachment.getSort(term));
            strategoInput = this.termFactory.makeTuple(sort, term);
            proposals = null;
            try {
                proposals = this.strategoCommon.invoke(runtime, strategoInput, "get-proposals-left-recursive-" + languageName);
            }
            catch (Exception e) {
                logger.error("Getting proposals for {} failed", (Object)term);
                continue;
            }
            if (proposals == null) {
                logger.error("Getting proposals for {} failed", (Object)term);
                continue;
            }
            for (IStrategoTerm proposalTerm : proposals) {
                tuple = TermUtils.toTuple(proposalTerm);
                if (!(tuple.getSubtermCount() == 5 && TermUtils.isStringAt(tuple, 0) && TermUtils.isStringAt(tuple, 1) && TermUtils.isStringAt(tuple, 2) && TermUtils.isApplAt(tuple, 3) && TermUtils.isStringAt(tuple, 4))) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                name = TermUtils.toJavaStringAt(tuple, 0);
                text = TermUtils.toJavaStringAt(tuple, 1);
                additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
                change = TermUtils.toApplAt(tuple, 3);
                String prefix = TermUtils.toJavaStringAt(tuple, 4);
                if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
                completion = this.createCompletionReplaceTerm(name, text, additionalInfo, change, false, prefix, "");
                if (completion == null) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                completions.add(completion);
            }
        }
        for (IStrategoTerm term : rightRecursive) {
            sort = this.termFactory.makeString(ImploderAttachment.getSort(term));
            strategoInput = this.termFactory.makeTuple(sort, term);
            proposals = null;
            try {
                proposals = this.strategoCommon.invoke(runtime, strategoInput, "get-proposals-right-recursive-" + languageName);
            }
            catch (Exception e) {
                logger.error("Getting proposals for {} failed", (Object)term);
                continue;
            }
            if (proposals == null) {
                logger.error("Getting proposals for {} failed", (Object)term);
                continue;
            }
            for (IStrategoTerm proposalTerm : proposals) {
                tuple = (IStrategoTuple)proposalTerm;
                if (!(tuple.getSubtermCount() == 5 && TermUtils.isString(tuple.getSubterm(0)) && TermUtils.isString(tuple.getSubterm(1)) && TermUtils.isString(tuple.getSubterm(2)) && TermUtils.isAppl(tuple.getSubterm(3)) && TermUtils.isString(tuple.getSubterm(4)))) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                name = TermUtils.toJavaStringAt(tuple, 0);
                text = TermUtils.toJavaStringAt(tuple, 1);
                additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
                change = TermUtils.toApplAt(tuple, 3);
                String suffix = TermUtils.toJavaStringAt(tuple, 4);
                if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
                completion = this.createCompletionReplaceTerm(name, text, additionalInfo, change, false, "", suffix);
                if (completion == null) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                completions.add(completion);
            }
        }
        return completions;
    }

    public Collection<ICompletion> placeholderCompletions(IStrategoAppl placeholder, String languageName, ILanguageComponent component, FileObject location) throws MetaborgException {
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
        IStrategoTerm placeholderParent = ParentAttachment.getParent(placeholder);
        if (placeholderParent == null) {
            placeholderParent = placeholder;
        }
        IStrategoInt placeholderIdx = this.termFactory.makeInt(-1);
        int i = 0;
        while (i < placeholderParent.getSubtermCount()) {
            if (placeholderParent.getSubterm(i) == placeholder) {
                placeholderIdx = this.termFactory.makeInt(i);
            }
            ++i;
        }
        String sort = ImploderAttachment.getSort(placeholder);
        IStrategoTuple strategoInput = this.termFactory.makeTuple(this.termFactory.makeString(sort), placeholder, placeholderParent, placeholderIdx);
        IStrategoTerm proposalsPlaceholder = this.strategoCommon.invoke(runtime, strategoInput, "get-proposals-placeholder-" + languageName);
        if (proposalsPlaceholder == null) {
            logger.error("Getting proposals for {} failed", (Object)placeholder);
            return completions;
        }
        for (IStrategoTerm proposalTerm : proposalsPlaceholder) {
            if (!TermUtils.isTuple(proposalTerm)) {
                logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                continue;
            }
            IStrategoTuple tuple = TermUtils.toTuple(proposalTerm);
            if (!(tuple.getSubtermCount() == 4 && TermUtils.isStringAt(tuple, 0) && TermUtils.isStringAt(tuple, 1) && TermUtils.isStringAt(tuple, 2) && TermUtils.isApplAt(tuple, 3))) {
                logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                continue;
            }
            String name = TermUtils.toJavaStringAt(tuple, 0);
            String text = TermUtils.toJavaStringAt(tuple, 1);
            String additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
            IStrategoAppl change = TermUtils.toApplAt(tuple, 3);
            if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
            ICompletion completion = this.createCompletionReplaceTerm(name, text, additionalInfo, change, false, "", "");
            if (completion == null) {
                logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                continue;
            }
            completions.add(completion);
        }
        return completions;
    }

    public Collection<ICompletion> optionalCompletions(Iterable<IStrategoTerm> optionals, boolean blankLineCompletion, String languageName, ILanguageComponent component, FileObject location) throws MetaborgException {
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        for (IStrategoTerm optional : optionals) {
            ImploderAttachment attachment = optional.getAttachment(ImploderAttachment.TYPE);
            String sort = attachment.getSort().substring(0, attachment.getSort().length());
            String placeholderName = String.valueOf(sort) + "-Plhdr";
            IStrategoAppl optionalPlaceholder = this.termFactory.makeAppl(this.termFactory.makeConstructor(placeholderName, 0), new IStrategoTerm[0]);
            IStrategoTuple strategoInput = this.termFactory.makeTuple(this.termFactory.makeString(sort), optional, optionalPlaceholder);
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            IStrategoTerm proposalsOptional = this.strategoCommon.invoke(runtime, strategoInput, "get-proposals-optional-" + languageName);
            if (proposalsOptional == null) {
                logger.error("Getting proposals for {} failed", (Object)strategoInput);
                continue;
            }
            for (IStrategoTerm proposalTerm : proposalsOptional) {
                if (!TermUtils.isTuple(proposalTerm)) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                IStrategoTuple tuple = TermUtils.toTuple(proposalTerm);
                if (!(tuple.getSubtermCount() == 4 && TermUtils.isStringAt(tuple, 0) && TermUtils.isStringAt(tuple, 1) && TermUtils.isStringAt(tuple, 2) && TermUtils.isApplAt(tuple, 2))) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                String name = TermUtils.toJavaStringAt(tuple, 0);
                String text = TermUtils.toJavaStringAt(tuple, 1);
                String additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
                IStrategoAppl change = TermUtils.toApplAt(tuple, 3);
                if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
                ICompletion completion = this.createCompletionReplaceTerm(name, text, additionalInfo, change, blankLineCompletion, "", "");
                if (completion == null) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                completions.add(completion);
            }
        }
        return completions;
    }

    public Collection<ICompletion> listsCompletions(int position, boolean blankLineCompletion, Iterable<IStrategoList> lists, String languageName, ILanguageComponent component, FileObject location) throws MetaborgException {
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        for (IStrategoList list : lists) {
            ListImploderAttachment attachment = (ListImploderAttachment)list.getAttachment(null);
            String sort = attachment.getSort().substring(0, attachment.getSort().length() - 1);
            String placeholderName = String.valueOf(sort) + "-Plhdr";
            IStrategoAppl listPlaceholder = this.termFactory.makeAppl(this.termFactory.makeConstructor(placeholderName, 0), new IStrategoTerm[0]);
            IStrategoTuple strategoInput = this.termFactory.makeTuple(this.termFactory.makeString(sort), list, listPlaceholder, this.termFactory.makeInt(position));
            HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
            IStrategoTerm proposalsLists = this.strategoCommon.invoke(runtime, strategoInput, "get-proposals-list-" + languageName);
            if (proposalsLists == null) {
                logger.error("Getting proposals for {} failed", (Object)strategoInput);
                continue;
            }
            for (IStrategoTerm proposalTerm : proposalsLists) {
                ICompletion completion;
                if (!TermUtils.isTuple(proposalTerm)) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                IStrategoTuple tuple = TermUtils.toTuple(proposalTerm);
                if (!(tuple.getSubtermCount() == 4 && TermUtils.isStringAt(tuple, 0) && TermUtils.isStringAt(tuple, 1) && TermUtils.isStringAt(tuple, 2) && TermUtils.isApplAt(tuple, 3))) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                String name = TermUtils.toJavaStringAt(tuple, 0);
                String text = TermUtils.toJavaStringAt(tuple, 1);
                String additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
                IStrategoAppl change = TermUtils.toApplAt(tuple, 3);
                if (change.getConstructor().getName().contains("INSERT_AT_END")) {
                    completion = this.createCompletionInsertAtEnd(name, text, additionalInfo, change, blankLineCompletion);
                    if (completion == null) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    completions.add(completion);
                    continue;
                }
                if (!change.getConstructor().getName().contains("INSERT_BEFORE")) continue;
                completion = this.createCompletionInsertBefore(name, text, additionalInfo, change);
                if (completion == null) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                completions.add(completion);
            }
        }
        return completions;
    }

    private ICompletion createCompletionReplaceTerm(String name, String text, String additionalInfo, IStrategoAppl change, boolean blankLineCompletion, String prefix, String suffix) {
        int suffixPoint;
        int insertionPoint;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        if (change.getSubtermCount() != 2 || !TermUtils.isAppl(newNode) || !TermUtils.isAppl(oldNode)) {
            return null;
        }
        String sort = ImploderAttachment.getSort(oldNode);
        ImploderAttachment oldNodeIA = oldNode.getAttachment(ImploderAttachment.TYPE);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldNode);
        if (oldNodeIA.getLeftToken().getStartOffset() > oldNodeIA.getRightToken().getEndOffset()) {
            int tokenPosition = oldNodeIA.getLeftToken().getIndex() - 1 > 0 ? oldNodeIA.getLeftToken().getIndex() - 1 : 0;
            while (tokenPosition > 0 && (tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR)) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
            if (!additionalInfo.contains("\n")) {
                tokenPosition = oldNodeIA.getLeftToken().getIndex() + 1 < tokenizer.getTokenCount() ? oldNodeIA.getLeftToken().getIndex() + 1 : tokenizer.getTokenCount() - 1;
                while (tokenPosition < tokenizer.getTokenCount() && (tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR)) {
                    ++tokenPosition;
                }
                suffixPoint = tokenizer.getTokenAt(tokenPosition).getStartOffset();
            } else {
                suffixPoint = insertionPoint + 1;
            }
            boolean blankLine = false;
            if (blankLineCompletion) {
                while (tokenPosition < tokenizer.getTokenCount()) {
                    Token checkToken = tokenizer.getTokenAt(tokenPosition);
                    if (tokenizer.toString(checkToken, checkToken).contains("\n")) {
                        suffixPoint = checkToken.getEndOffset();
                        if (blankLine) break;
                        blankLine = true;
                    }
                    ++tokenPosition;
                }
            }
        } else {
            insertionPoint = oldNodeIA.getLeftToken().getStartOffset() - 1;
            suffixPoint = oldNodeIA.getRightToken().getEndOffset() + 1;
        }
        CompletionKind kind = prefix.equals("") && suffix.equals("") ? CompletionKind.expansion : CompletionKind.expansionEditing;
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, kind, prefix, suffix);
    }

    private ICompletion createCompletionInsertBefore(String name, String text, String additionalInfo, IStrategoAppl change) {
        int insertionPoint;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        IStrategoTerm oldList = ParentAttachment.getParent(oldNode);
        if (!(change.getSubtermCount() == 2 && TermUtils.isAppl(oldNode) && TermUtils.isList(newNode) && TermUtils.isList(oldList))) {
            return null;
        }
        String sort = ImploderAttachment.getSort(oldNode);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldNode);
        IStrategoTerm[] subterms = oldList.getAllSubterms();
        int indexOfElement = 0;
        while (indexOfElement < subterms.length) {
            if (subterms[indexOfElement] == oldNode) break;
            ++indexOfElement;
        }
        if (indexOfElement == 0) {
            ImploderAttachment oldNodeIA = oldNode.getAttachment(ImploderAttachment.TYPE);
            int tokenPosition = oldNodeIA.getLeftToken().getIndex() - 1 > 0 ? oldNodeIA.getLeftToken().getIndex() - 1 : 0;
            while ((tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR) && tokenPosition > 0) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        } else {
            IStrategoTerm elementBefore = oldList.getSubterm(indexOfElement - 1);
            insertionPoint = elementBefore.getAttachment(ImploderAttachment.TYPE).getRightToken().getEndOffset();
        }
        String separator = "";
        int i = text.length() - 1;
        while (i >= 0) {
            if (text.charAt(i) == additionalInfo.charAt(additionalInfo.length() - 1)) break;
            separator = String.valueOf(text.charAt(i)) + separator;
            --i;
        }
        IToken checkToken = oldNode.getAttachment(ImploderAttachment.TYPE).getLeftToken();
        int checkTokenIdx = oldNode.getAttachment(ImploderAttachment.TYPE).getLeftToken().getIndex();
        int suffixPoint = insertionPoint;
        if (separator.contains("\n")) {
            while (checkTokenIdx >= 0) {
                checkToken = tokenizer.getTokenAt(checkTokenIdx);
                if (!tokenizer.toString(checkToken, checkToken).contains("\n")) {
                    suffixPoint = checkToken.getStartOffset();
                    --checkTokenIdx;
                    continue;
                }
                break;
            }
        } else {
            suffixPoint = checkToken.getStartOffset();
        }
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, CompletionKind.expansion);
    }

    private ICompletion createCompletionInsertAtEnd(String name, String text, String additionalInfo, IStrategoAppl change, boolean blankLineCompletion) {
        int insertionPoint;
        int tokenPosition;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        if (change.getSubtermCount() != 2 || !TermUtils.isList(oldNode) || !TermUtils.isList(newNode)) {
            return null;
        }
        String sort = ImploderAttachment.getElementSort(oldNode);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldNode);
        ImploderAttachment oldListIA = oldNode.getAttachment(ImploderAttachment.TYPE);
        if (oldNode.getSubtermCount() == 0) {
            tokenPosition = oldListIA.getLeftToken().getIndex() - 1 > 0 ? oldListIA.getLeftToken().getIndex() - 1 : 0;
            while ((tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR) && tokenPosition > 0) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        } else {
            IStrategoTerm elementBefore = oldNode.getSubterm(oldNode.getAllSubterms().length - 1);
            int leftIdx = elementBefore.getAttachment(ImploderAttachment.TYPE).getLeftToken().getIndex();
            int rightIdx = elementBefore.getAttachment(ImploderAttachment.TYPE).getRightToken().getIndex();
            while ((tokenizer.getTokenAt(rightIdx).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(rightIdx).getLength() == 0) && rightIdx > leftIdx) {
                --rightIdx;
            }
            insertionPoint = tokenizer.getTokenAt(rightIdx).getEndOffset();
            tokenPosition = rightIdx;
        }
        int suffixPoint = insertionPoint + 1;
        boolean blankLine = false;
        if (blankLineCompletion) {
            while (tokenPosition < tokenizer.getTokenCount()) {
                Token checkToken = tokenizer.getTokenAt(tokenPosition);
                if (tokenizer.toString(checkToken, checkToken).contains("\n")) {
                    suffixPoint = checkToken.getEndOffset();
                    if (blankLine) break;
                    blankLine = true;
                }
                ++tokenPosition;
            }
        }
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, CompletionKind.expansion);
    }

    public Collection<ICompletion> completionErroneousPrograms(int cursorPosition, Iterable<IStrategoTerm> completionTerms, ISpoofaxParseUnit completionParseResult) throws MetaborgException {
        FileObject location = completionParseResult.source();
        ILanguageImpl language = completionParseResult.input().langImpl();
        String languageName = language.belongsTo().name();
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        LinkedList<IStrategoTerm> proposalsTerm = new LinkedList<IStrategoTerm>();
        for (ILanguageComponent component : language.components()) {
            for (IStrategoTerm completionTerm : completionTerms) {
                IStrategoTerm completionAst = completionParseResult.ast();
                IStrategoTerm topMostAmb = this.findTopMostAmbNode(completionTerm);
                if (ImploderAttachment.get(completionTerm).isSinglePlaceholderCompletion()) {
                    LinkedList<IStrategoTerm> placeholders = new LinkedList<IStrategoTerm>();
                    placeholders.addAll(this.findPlaceholderTerms(completionTerm));
                    if (placeholders.size() != 1) {
                        logger.error("Getting proposals for {} failed", (Object)completionTerm);
                        continue;
                    }
                    IStrategoAppl placeholderTerm = (IStrategoAppl)placeholders.iterator().next();
                    IStrategoAppl placeholder = this.termFactory.makeAppl(this.termFactory.makeConstructor(placeholderTerm.getConstructor().getName(), 0), new IStrategoTerm[0]);
                    IStrategoTerm parenthesized = this.parenthesizeTerm(completionTerm, this.termFactory);
                    IStrategoTuple inputStratego = this.termFactory.makeTuple(this.termFactory.makeString(ImploderAttachment.getElementSort(parenthesized)), completionAst, completionTerm, topMostAmb, parenthesized, placeholder, placeholderTerm);
                    HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
                    IStrategoTerm proposalTerm = this.strategoCommon.invoke(runtime, inputStratego, "get-proposals-incorrect-programs-single-placeholder-" + languageName);
                    if (proposalTerm == null || !TermUtils.isList(proposalTerm)) {
                        logger.error("Getting proposals for {} failed", (Object)completionTerm);
                        continue;
                    }
                    for (IStrategoTerm proposalPlaceholder : proposalTerm) {
                        proposalsTerm.add(proposalPlaceholder);
                    }
                    continue;
                }
                IStrategoTerm parenthesized = this.parenthesizeTerm(completionTerm, this.termFactory);
                IStrategoTuple inputStratego = this.termFactory.makeTuple(this.termFactory.makeString(ImploderAttachment.getElementSort(parenthesized)), completionAst, completionTerm, topMostAmb, parenthesized);
                HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
                IStrategoTerm proposalTerm = this.strategoCommon.invoke(runtime, inputStratego, "get-proposals-incorrect-programs-" + languageName);
                if (proposalTerm == null) {
                    logger.error("Getting proposals for {} failed", (Object)completionTerm);
                    continue;
                }
                proposalsTerm.add(proposalTerm);
            }
            for (IStrategoTerm proposalTerm : proposalsTerm) {
                ICompletion completion;
                if (!TermUtils.isTuple(proposalTerm)) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                IStrategoTuple tuple = TermUtils.toTuple(proposalTerm);
                if (!(tuple.getSubtermCount() == 6 && TermUtils.isStringAt(tuple, 0) && TermUtils.isStringAt(tuple, 1) && TermUtils.isStringAt(tuple, 2) && TermUtils.isApplAt(tuple, 3) && tuple.getSubterm(4) != null && TermUtils.isStringAt(tuple, 5))) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                String name = TermUtils.toJavaStringAt(tuple, 0);
                String text = TermUtils.toJavaStringAt(tuple, 1);
                String additionalInfo = TermUtils.toJavaStringAt(tuple, 2);
                IStrategoAppl change = TermUtils.toApplAt(tuple, 3);
                IStrategoTerm completionTerm = tuple.getSubterm(4);
                String completionKind = TermUtils.toJavaStringAt(tuple, 5);
                String prefix = this.calculatePrefix(cursorPosition, completionTerm);
                String suffix = this.calculateSuffix(cursorPosition, completionTerm);
                if (change.getConstructor().getName().contains("INSERT_AT_END")) {
                    completion = this.createCompletionInsertAtEndFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                    if (completion == null) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    completions.add(completion);
                    continue;
                }
                if (change.getConstructor().getName().contains("INSERT_BEFORE")) {
                    completion = this.createCompletionInsertBeforeFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                    if (completion == null) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    completions.add(completion);
                    continue;
                }
                if (change.getConstructor().getName().contains("INSERTION_TERM")) {
                    completion = this.createCompletionInsertionTermFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                    if (completion == null) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                        continue;
                    }
                    completions.add(completion);
                    continue;
                }
                if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
                completion = this.createCompletionReplaceTermFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                if (completion == null) {
                    logger.error("Unexpected proposal term {}, skipping", (Object)proposalTerm);
                    continue;
                }
                completions.add(completion);
            }
        }
        return completions;
    }

    private String calculatePrefix(int cursorPosition, IStrategoTerm proposalTerm) {
        String prefix = "";
        IToken leftToken = proposalTerm.getAttachment(ImploderAttachment.TYPE).getLeftToken();
        IToken rightToken = proposalTerm.getAttachment(ImploderAttachment.TYPE).getRightToken();
        ITokenizer tokenizer = (ITokenizer)leftToken.getTokenizer();
        IToken current = leftToken;
        int endOffsetPrefix = Integer.MIN_VALUE;
        while (current.getEndOffset() < cursorPosition && current != rightToken) {
            if (endOffsetPrefix < current.getEndOffset()) {
                prefix = String.valueOf(prefix) + current.toString();
                endOffsetPrefix = current.getEndOffset();
            }
            current = tokenizer.getTokenAt(current.getIndex() + 1);
        }
        return prefix;
    }

    private String calculateSuffix(int cursorPosition, IStrategoTerm proposalTerm) {
        String suffix = "";
        IToken leftToken = proposalTerm.getAttachment(ImploderAttachment.TYPE).getLeftToken();
        IToken rightToken = proposalTerm.getAttachment(ImploderAttachment.TYPE).getRightToken();
        ITokenizer tokenizer = (ITokenizer)leftToken.getTokenizer();
        IToken current = rightToken;
        int startOffsetSuffix = Integer.MAX_VALUE;
        while (current.getStartOffset() >= cursorPosition && current != leftToken) {
            if (startOffsetSuffix > current.getStartOffset()) {
                suffix = String.valueOf(current.toString()) + suffix;
                startOffsetSuffix = current.getStartOffset();
            }
            current = tokenizer.getTokenAt(current.getIndex() - 1);
        }
        return suffix;
    }

    private ICompletion createCompletionInsertionTermFixing(String name, String text, String additionalInfo, String prefix, String suffix, IStrategoAppl change, String completionKind) {
        int suffixPoint;
        IStrategoTerm newNode = change.getSubterm(0);
        if (change.getSubtermCount() != 1 || !TermUtils.isAppl(newNode)) {
            return null;
        }
        String sort = ImploderAttachment.getSort(newNode);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(newNode);
        IStrategoTerm topMostAmb = this.findTopMostAmbNode(newNode);
        ImploderAttachment topMostAmbIA = topMostAmb.getAttachment(ImploderAttachment.TYPE);
        int tokenPosition = topMostAmbIA.getLeftToken().getIndex() - 1 > 0 ? topMostAmbIA.getLeftToken().getIndex() - 1 : 0;
        while ((tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR) && tokenPosition > 0) {
            --tokenPosition;
        }
        int insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        if (topMostAmbIA.getRightToken().getEndOffset() < topMostAmbIA.getRightToken().getStartOffset()) {
            tokenPosition = topMostAmbIA.getRightToken().getIndex();
            while (tokenPosition > 0 && (tokenizer.getTokenAt(tokenPosition).getEndOffset() < tokenizer.getTokenAt(tokenPosition).getStartOffset() || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT)) {
                --tokenPosition;
            }
            suffixPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset() + 1;
        } else {
            suffixPoint = topMostAmbIA.getRightToken().getEndOffset() + 1;
        }
        CompletionKind kind = completionKind.equals("recovery") ? CompletionKind.recovery : (completionKind.equals("expansionEditing") ? CompletionKind.expansionEditing : CompletionKind.expansion);
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, kind, prefix, suffix);
    }

    private ICompletion createCompletionInsertBeforeFixing(String name, String text, String additionalInfo, String prefix, String suffix, IStrategoAppl change, String completionKind) {
        int insertionPoint;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        IStrategoTerm oldList = ParentAttachment.getParent(oldNode);
        if (!(change.getSubtermCount() == 2 && TermUtils.isAppl(oldNode) && TermUtils.isAppl(newNode) && TermUtils.isList(oldList))) {
            return null;
        }
        String sort = ImploderAttachment.getSort(oldNode);
        IStrategoTerm[] subterms = TermUtils.toList(oldList).getAllSubterms();
        int indexOfCompletion = 0;
        while (indexOfCompletion < subterms.length) {
            if (subterms[indexOfCompletion] == oldNode) break;
            ++indexOfCompletion;
        }
        if (indexOfCompletion == 1) {
            ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldList);
            IStrategoTerm topMostAmbOldList = this.findTopMostAmbNode(oldList);
            ImploderAttachment oldListIA = topMostAmbOldList.getAttachment(ImploderAttachment.TYPE);
            int tokenPosition = oldListIA.getLeftToken().getIndex() - 1 > 0 ? oldListIA.getLeftToken().getIndex() - 1 : 0;
            while ((this.checkEmptyOffset(tokenizer.getTokenAt(tokenPosition)) || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR) && tokenPosition > 0) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        } else {
            IStrategoTerm elementBefore = oldList.getSubterm(indexOfCompletion - 2);
            insertionPoint = elementBefore.getAttachment(ImploderAttachment.TYPE).getRightToken().getEndOffset();
        }
        int suffixPoint = oldNode.getAttachment(ImploderAttachment.TYPE).getLeftToken().getStartOffset();
        CompletionKind kind = completionKind.equals("recovery") ? CompletionKind.recovery : (completionKind.equals("expansionEditing") ? CompletionKind.expansionEditing : CompletionKind.expansion);
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, kind, prefix, suffix);
    }

    private ICompletion createCompletionInsertAtEndFixing(String name, String text, String additionalInfo, String prefix, String suffix, IStrategoAppl change, String completionKind) {
        int insertionPoint;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        IStrategoTerm oldNodeTopMostAmb = this.findTopMostAmbNode(oldNode);
        if (change.getSubtermCount() != 2 || !TermUtils.isList(oldNode) || !TermUtils.isAppl(newNode)) {
            return null;
        }
        String sort = ImploderAttachment.getElementSort(oldNode);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldNodeTopMostAmb);
        ImploderAttachment oldNodeIA = oldNodeTopMostAmb.getAttachment(ImploderAttachment.TYPE);
        if (((IStrategoList)oldNode).size() == 1) {
            int tokenPosition = oldNodeIA.getLeftToken().getIndex() - 1 > 0 ? oldNodeIA.getLeftToken().getIndex() - 1 : 0;
            while (tokenPosition > 0 && (this.checkEmptyOffset(tokenizer.getTokenAt(tokenPosition)) || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR)) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        } else {
            IStrategoTerm elementBefore = oldNode.getSubterm(oldNode.getAllSubterms().length - 2);
            insertionPoint = elementBefore.getAttachment(ImploderAttachment.TYPE).getRightToken().getEndOffset();
        }
        int tokenPosition = oldNodeIA.getRightToken().getIndex();
        while (tokenizer.getTokenAt(tokenPosition).getEndOffset() < tokenizer.getTokenAt(tokenPosition).getStartOffset() || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT && tokenPosition > 0) {
            --tokenPosition;
        }
        int suffixPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset() + 1;
        CompletionKind kind = completionKind.equals("recovery") ? CompletionKind.recovery : (completionKind.equals("expansionEditing") ? CompletionKind.expansionEditing : CompletionKind.expansion);
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, kind, prefix, suffix);
    }

    private boolean isCompletionNode(ISimpleTerm term) {
        if (term == null) {
            return false;
        }
        return ImploderAttachment.get(term).isCompletion() || ImploderAttachment.get(term).isNestedCompletion();
    }

    public Collection<? extends ICompletion> completionErroneousProgramsNested(int cursorPosition, Collection<IStrategoTerm> nestedCompletionTerms, ISpoofaxParseUnit completionParseResult) throws MetaborgException {
        FileObject location = completionParseResult.source();
        ILanguageImpl language = completionParseResult.input().langImpl();
        String languageName = language.belongsTo().name();
        LinkedList<ICompletion> completions = new LinkedList<ICompletion>();
        IStrategoTerm completionAst = completionParseResult.ast();
        for (ILanguageComponent component : language.components()) {
            for (IStrategoTerm nestedCompletionTerm : nestedCompletionTerms) {
                HybridInterpreter runtime = this.strategoRuntimeService.runtime(component, location);
                LinkedList<IStrategoTerm> inputsStrategoNested = new LinkedList<IStrategoTerm>();
                inputsStrategoNested.addAll(this.calculateDirectCompletionProposals(nestedCompletionTerm, this.termFactory, completionAst, languageName, runtime));
                Collection<IStrategoTerm> innerNestedCompletionTerms = this.findNestedCompletionTerm((StrategoTerm)nestedCompletionTerm, true);
                for (IStrategoTerm innerNestedCompletionTerm : innerNestedCompletionTerms) {
                    inputsStrategoNested.addAll(this.calculateNestedCompletionProposals(nestedCompletionTerm, innerNestedCompletionTerm, this.termFactory, completionAst, languageName, runtime));
                }
                for (IStrategoTerm inputStrategoNested : inputsStrategoNested) {
                    ICompletion completion;
                    IStrategoTerm proposalTermNested = this.strategoCommon.invoke(runtime, inputStrategoNested, "get-proposals-incorrect-programs-nested-" + languageName);
                    if (proposalTermNested == null) {
                        logger.error("Getting proposals for {} failed", (Object)inputStrategoNested);
                        continue;
                    }
                    String name = TermUtils.toJavaStringAt(proposalTermNested, 0);
                    String text = TermUtils.toJavaStringAt(proposalTermNested, 1);
                    String additionalInfo = TermUtils.toJavaStringAt(proposalTermNested, 2);
                    IStrategoAppl change = TermUtils.toApplAt(proposalTermNested, 3);
                    IStrategoTerm completionTerm = proposalTermNested.getSubterm(4);
                    String prefix = this.calculatePrefix(cursorPosition, completionTerm);
                    String suffix = this.calculateSuffix(cursorPosition, completionTerm);
                    String completionKind = "recovery";
                    if (change.getConstructor().getName().contains("INSERT_AT_END")) {
                        completion = this.createCompletionInsertAtEndFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                        if (completion == null) {
                            logger.error("Unexpected proposal term {}, skipping", (Object)proposalTermNested);
                            continue;
                        }
                        completions.add(completion);
                        continue;
                    }
                    if (change.getConstructor().getName().contains("INSERT_BEFORE")) {
                        completion = this.createCompletionInsertBeforeFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                        if (completion == null) {
                            logger.error("Unexpected proposal term {}, skipping", (Object)proposalTermNested);
                            continue;
                        }
                        completions.add(completion);
                        continue;
                    }
                    if (change.getConstructor().getName().contains("INSERTION_TERM")) {
                        completion = this.createCompletionInsertionTermFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                        if (completion == null) {
                            logger.error("Unexpected proposal term {}, skipping", (Object)proposalTermNested);
                            continue;
                        }
                        completions.add(completion);
                        continue;
                    }
                    if (!change.getConstructor().getName().contains("REPLACE_TERM")) continue;
                    completion = this.createCompletionReplaceTermFixing(name, text, additionalInfo, prefix, suffix, change, completionKind);
                    if (completion == null) {
                        logger.error("Unexpected proposal term {}, skipping", (Object)proposalTermNested);
                        continue;
                    }
                    completions.add(completion);
                }
            }
        }
        return completions;
    }

    private Collection<IStrategoTerm> calculateNestedCompletionProposals(IStrategoTerm mainNestedCompletionTerm, IStrategoTerm nestedCompletionTerm, ITermFactory termFactory, IStrategoTerm completionAst, String languageName, HybridInterpreter runtime) throws MetaborgException {
        LinkedList<IStrategoTerm> inputsStratego = new LinkedList<IStrategoTerm>();
        Collection<IStrategoTerm> nestedCompletionTerms = this.findNestedCompletionTerm(nestedCompletionTerm, true);
        for (IStrategoTerm innerNestedCompletionTerm : nestedCompletionTerms) {
            Collection<IStrategoTerm> inputsStrategoInnerNested = this.calculateNestedCompletionProposals(nestedCompletionTerm, innerNestedCompletionTerm, termFactory, completionAst, languageName, runtime);
            for (IStrategoTerm inputStrategoNested : inputsStrategoInnerNested) {
                IStrategoTerm proposalTermNested = this.strategoCommon.invoke(runtime, inputStrategoNested, "get-proposals-incorrect-programs-nested-" + languageName);
                if (proposalTermNested == null) {
                    logger.error("Getting proposals for {} failed", (Object)inputStrategoNested);
                    continue;
                }
                IStrategoTerm topMostAmb = this.findTopMostAmbNode(nestedCompletionTerm);
                IStrategoAppl replaceTermText = termFactory.makeAppl((IStrategoConstructor)new StrategoConstructor("REPLACE_TERM_TEXT", 2), topMostAmb, proposalTermNested.getSubterm(1));
                IStrategoTerm parenthesized = this.parenthesizeTerm(mainNestedCompletionTerm, termFactory);
                IStrategoTuple inputStrategoInnerNested = termFactory.makeTuple(termFactory.makeString(ImploderAttachment.getElementSort(parenthesized)), completionAst, mainNestedCompletionTerm, proposalTermNested.getSubterm(0), replaceTermText, parenthesized);
                inputsStratego.add(inputStrategoInnerNested);
            }
        }
        Collection<IStrategoTerm> inputsStrategoInner = this.calculateDirectCompletionProposals(nestedCompletionTerm, termFactory, completionAst, languageName, runtime);
        for (IStrategoTerm inputStrategoNested : inputsStrategoInner) {
            IStrategoTerm proposalTermNested = this.strategoCommon.invoke(runtime, inputStrategoNested, "get-proposals-incorrect-programs-nested-" + languageName);
            if (proposalTermNested == null) {
                logger.error("Getting proposals for {} failed", (Object)inputStrategoNested);
                continue;
            }
            IStrategoTerm topMostAmb = this.findTopMostAmbNode(nestedCompletionTerm);
            IStrategoAppl replaceTermText = termFactory.makeAppl((IStrategoConstructor)new StrategoConstructor("REPLACE_TERM_TEXT", 2), topMostAmb, proposalTermNested.getSubterm(1));
            IStrategoTerm parenthesized = this.parenthesizeTerm(mainNestedCompletionTerm, termFactory);
            IStrategoTuple inputStrategoInnerNested = termFactory.makeTuple(termFactory.makeString(ImploderAttachment.getElementSort(parenthesized)), completionAst, mainNestedCompletionTerm, proposalTermNested.getSubterm(0), replaceTermText, parenthesized);
            inputsStratego.add(inputStrategoInnerNested);
        }
        return inputsStratego;
    }

    private Collection<IStrategoTerm> calculateDirectCompletionProposals(IStrategoTerm nestedCompletionTerm, ITermFactory termFactory, IStrategoTerm completionAst, String languageName, HybridInterpreter runtime) throws MetaborgException {
        LinkedList<IStrategoTerm> inputsStratego = new LinkedList<IStrategoTerm>();
        Collection<IStrategoTerm> completionTerms = this.findCompletionTermInsideNested(nestedCompletionTerm);
        for (IStrategoTerm completionTerm : completionTerms) {
            IStrategoTerm topMostCompletionTerm = this.findTopMostCompletionNode(completionTerm);
            IStrategoTerm topMostAmb = this.findTopMostAmbNode(topMostCompletionTerm);
            IStrategoTerm parenthesized = this.parenthesizeTerm(topMostCompletionTerm, termFactory);
            IStrategoTuple inputStratego = termFactory.makeTuple(termFactory.makeString(ImploderAttachment.getElementSort(parenthesized)), completionAst, completionTerm, topMostAmb, parenthesized);
            IStrategoTerm proposalTerm = this.strategoCommon.invoke(runtime, inputStratego, "get-proposals-incorrect-programs-" + languageName);
            if (proposalTerm == null) {
                logger.error("Getting proposals for {} failed", (Object)inputStratego);
                continue;
            }
            IStrategoAppl replaceTermText = termFactory.makeAppl((IStrategoConstructor)new StrategoConstructor("REPLACE_TERM_TEXT", 2), topMostAmb, proposalTerm.getSubterm(1));
            IStrategoTerm parenthesizedNested = this.parenthesizeTerm(nestedCompletionTerm, termFactory);
            IStrategoTuple inputStrategoNested = termFactory.makeTuple(termFactory.makeString(ImploderAttachment.getElementSort(parenthesizedNested)), completionAst, nestedCompletionTerm, proposalTerm.getSubterm(0), replaceTermText, parenthesizedNested);
            inputsStratego.add(inputStrategoNested);
        }
        return inputsStratego;
    }

    private IStrategoTerm parenthesizeTerm(IStrategoTerm completionTerm, ITermFactory termFactory) {
        if (ImploderAttachment.get(completionTerm).isBracket()) {
            IStrategoAppl result = termFactory.makeAppl(termFactory.makeConstructor("Parenthetical", 1), completionTerm);
            return result;
        }
        return completionTerm;
    }

    private ICompletion createCompletionReplaceTermFixing(String name, String text, String additionalInfo, String prefix, String suffix, IStrategoAppl change, String completionKind) {
        int insertionPoint;
        IStrategoTerm oldNode = change.getSubterm(0);
        IStrategoTerm newNode = change.getSubterm(1);
        if (change.getSubtermCount() != 2 || !TermUtils.isAppl(newNode) || !TermUtils.isAppl(oldNode)) {
            return null;
        }
        String sort = ImploderAttachment.getSort(oldNode);
        ImploderAttachment oldNodeIA = oldNode.getAttachment(ImploderAttachment.TYPE);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(oldNode);
        if (oldNodeIA.getLeftToken().getStartOffset() > oldNodeIA.getRightToken().getEndOffset()) {
            int tokenPosition = oldNodeIA.getLeftToken().getIndex() - 1 > 0 ? oldNodeIA.getLeftToken().getIndex() - 1 : 0;
            while ((tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPosition).getKind() == IToken.Kind.TK_ERROR) && tokenPosition > 0) {
                --tokenPosition;
            }
            insertionPoint = tokenizer.getTokenAt(tokenPosition).getEndOffset();
        } else {
            insertionPoint = oldNodeIA.getLeftToken().getStartOffset() - 1;
        }
        int tokenPositionEnd = oldNodeIA.getRightToken().getIndex();
        while ((tokenizer.getTokenAt(tokenPositionEnd).getEndOffset() < tokenizer.getTokenAt(tokenPositionEnd).getStartOffset() || tokenizer.getTokenAt(tokenPositionEnd).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(tokenPositionEnd).getKind() == IToken.Kind.TK_ERROR) && tokenPositionEnd > 0) {
            --tokenPositionEnd;
        }
        int suffixPoint = tokenizer.getTokenAt(tokenPositionEnd).getEndOffset() + 1;
        CompletionKind kind = completionKind.equals("recovery") ? CompletionKind.recovery : CompletionKind.expansion;
        return new Completion(name, sort, text, additionalInfo, insertionPoint + 1, suffixPoint, kind, prefix, suffix);
    }

    private boolean checkEmptyOffset(IToken token) {
        return token.getStartOffset() > token.getEndOffset();
    }

    @Nullable
    private IStrategoAppl getPlaceholder(int position, Iterable<IStrategoTerm> terms) {
        for (IStrategoTerm term : terms) {
            if (!TermUtils.isAppl(term)) continue;
            IToken left = ImploderAttachment.getLeftToken(term);
            IToken right = ImploderAttachment.getRightToken(term);
            IStrategoAppl appl = (IStrategoAppl)term;
            if (!appl.getConstructor().getName().endsWith("-Plhdr") || position <= left.getStartOffset() || position > right.getEndOffset()) continue;
            return appl;
        }
        return null;
    }

    @Nullable
    private Iterable<IStrategoList> getLists(Iterable<IStrategoTerm> terms, Map<IStrategoTerm, Boolean> leftRecursiveTerms, Map<IStrategoTerm, Boolean> rightRecursiveTerms) {
        LinkedList<IStrategoList> lists = new LinkedList<IStrategoList>();
        for (IStrategoTerm term : terms) {
            if (TermUtils.isList(term)) {
                IStrategoList list = (IStrategoList)term;
                lists.add(list);
                continue;
            }
            IToken left = ImploderAttachment.getLeftToken(term);
            IToken right = ImploderAttachment.getRightToken(term);
            if (left.getStartOffset() > right.getEndOffset()) continue;
            boolean isLeftRecursive = leftRecursiveTerms.containsKey(term);
            boolean isRightRecursive = rightRecursiveTerms.containsKey(term);
            if (!isLeftRecursive && !isRightRecursive) break;
        }
        return lists;
    }

    @Nullable
    private Iterable<IStrategoTerm> getOptionals(Iterable<IStrategoTerm> terms, Map<IStrategoTerm, Boolean> leftRecursiveTerms, Map<IStrategoTerm, Boolean> rightRecursiveTerms) {
        LinkedList<IStrategoTerm> optionals = new LinkedList<IStrategoTerm>();
        for (IStrategoTerm term : terms) {
            IToken left = ImploderAttachment.getLeftToken(term);
            IToken right = ImploderAttachment.getRightToken(term);
            if (!TermUtils.isList(term) && left.getStartOffset() > right.getEndOffset()) {
                optionals.add(term);
                continue;
            }
            if (TermUtils.isList(term)) continue;
            boolean isLeftRecursive = leftRecursiveTerms.containsKey(term);
            boolean isRightRecursive = rightRecursiveTerms.containsKey(term);
            if (!isLeftRecursive && !isRightRecursive) break;
        }
        return optionals;
    }

    private Iterable<IStrategoTerm> getRightRecursiveTerms(int position, Iterable<IStrategoTerm> terms, Map<IStrategoTerm, Boolean> rightRecursiveTerms) {
        LinkedList<IStrategoTerm> rightRecursive = new LinkedList<IStrategoTerm>();
        for (IStrategoTerm term : terms) {
            boolean isRightRecursive = rightRecursiveTerms.containsKey(term);
            IToken left = ImploderAttachment.getLeftToken(term);
            IToken right = ImploderAttachment.getRightToken(term);
            if (isRightRecursive && position <= left.getStartOffset()) {
                rightRecursive.add(term);
                continue;
            }
            if (!TermUtils.isList(term) && left.getStartOffset() <= right.getEndOffset()) break;
        }
        return rightRecursive;
    }

    private Iterable<IStrategoTerm> getLeftRecursiveTerms(int position, Iterable<IStrategoTerm> terms, Map<IStrategoTerm, Boolean> leftRecursiveTerms) {
        LinkedList<IStrategoTerm> leftRecursive = new LinkedList<IStrategoTerm>();
        for (IStrategoTerm term : terms) {
            boolean isLeftRecursive = leftRecursiveTerms.containsKey(term);
            IToken left = ImploderAttachment.getLeftToken(term);
            IToken right = ImploderAttachment.getRightToken(term);
            if (isLeftRecursive && position > right.getEndOffset()) {
                leftRecursive.add(term);
                continue;
            }
            if (!TermUtils.isList(term) && left.getStartOffset() <= right.getEndOffset()) break;
        }
        return leftRecursive;
    }

    private Collection<IStrategoTerm> getCompletionTermsFromAST(ISpoofaxParseUnit completionParseResult) {
        if (completionParseResult == null) {
            return new LinkedList<IStrategoTerm>();
        }
        StrategoTerm ast = (StrategoTerm)completionParseResult.ast();
        if (ast == null) {
            return new LinkedList<IStrategoTerm>();
        }
        Collection<IStrategoTerm> completionTerm = this.findCompletionTerm(ast);
        return completionTerm;
    }

    private Collection<IStrategoTerm> getNestedCompletionTermsFromAST(ISpoofaxParseUnit completionParseResult) {
        if (completionParseResult == null) {
            return new LinkedList<IStrategoTerm>();
        }
        StrategoAppl ast = (StrategoAppl)completionParseResult.ast();
        if (ast == null) {
            return new LinkedList<IStrategoTerm>();
        }
        Collection<IStrategoTerm> completionTerm = this.findNestedCompletionTerm(ast, false);
        return completionTerm;
    }

    private Iterable<IStrategoTerm> tracingTermsCompletions(final int position, Object result, final ISourceRegion region, final HybridInterpreter runtime, final ITermFactory termFactory, final String languageName, final Map<IStrategoTerm, Boolean> leftRecursiveTerms, final Map<IStrategoTerm, Boolean> rightRecursiveTerms) {
        if (result == null || region == null) {
            return Iterables2.empty();
        }
        final LinkedList<IStrategoTerm> parsed = new LinkedList<IStrategoTerm>();
        AStrategoTermVisitor visitor = new AStrategoTermVisitor(){

            @Override
            public boolean visit(IStrategoTerm term) {
                ISourceLocation location = JSGLRCompletionService.this.fromTokens(term, runtime, termFactory, position, languageName, leftRecursiveTerms, rightRecursiveTerms);
                if (location != null && location.region().contains(region)) {
                    parsed.add(term);
                    return false;
                }
                return true;
            }
        };
        StrategoTermVisitee.bottomup(visitor, (IStrategoTerm)result);
        return parsed;
    }

    @Nullable
    protected ISourceLocation fromTokens(IStrategoTerm fragment, HybridInterpreter runtime, ITermFactory termFactory, int position, String languageName, Map<IStrategoTerm, Boolean> leftRecursiveTerms, Map<IStrategoTerm, Boolean> rightRecursiveTerms) {
        int i;
        FileObject resource = SourceAttachment.getResource(fragment, this.resourceService);
        IToken left = ImploderAttachment.getLeftToken(fragment);
        IToken right = ImploderAttachment.getRightToken(fragment);
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(fragment);
        IToken leftmostValid = left;
        IToken rightmostValid = right;
        boolean isList = TermUtils.isList(fragment);
        boolean isOptional = false;
        String sort = ImploderAttachment.getSort(fragment);
        IStrategoString input = termFactory.makeString(sort);
        boolean isLeftRecursive = false;
        if (TermUtils.isAppl(fragment) && position > right.getEndOffset()) {
            try {
                isLeftRecursive = this.strategoCommon.invoke(runtime, input, "is-left-recursive") != null;
            }
            catch (MetaborgException e) {
                logger.error("Failed to check recursivity for term {} of sort {} - syntactic completion not activated for this language, please import the completion stratego library", (Object)fragment, (Object)sort);
            }
        }
        boolean isRightRecursive = false;
        if (TermUtils.isAppl(fragment) && position <= left.getStartOffset()) {
            try {
                isRightRecursive = this.strategoCommon.invoke(runtime, input, "is-right-recursive") != null;
            }
            catch (MetaborgException e) {
                logger.error("Failed to check recursivity for term {} of sort {} - syntactic completion not activated for this language, please import the completion stratego library", (Object)fragment, (Object)sort);
            }
        }
        if (isLeftRecursive) {
            leftRecursiveTerms.put(fragment, true);
        }
        if (isRightRecursive) {
            rightRecursiveTerms.put(fragment, true);
        }
        if (left == null || right == null) {
            return null;
        }
        if (!isList && left == right && left.getEndOffset() < left.getStartOffset()) {
            isOptional = true;
        }
        if (left.getStartOffset() > right.getEndOffset() || isList || isOptional || isLeftRecursive && isRightRecursive) {
            i = left.getIndex() - 1;
            while (i >= 0) {
                if (tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_LAYOUT && tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_ERROR) break;
                leftmostValid = tokenizer.getTokenAt(i);
                --i;
            }
            i = right.getIndex() + 1;
            while (i < tokenizer.getTokenCount()) {
                if (tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_EOF || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_ERROR) {
                    rightmostValid = tokenizer.getTokenAt(i);
                    ++i;
                    continue;
                }
                break;
            }
        } else if (isLeftRecursive) {
            i = left.getIndex();
            while (i < right.getIndex()) {
                if (tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_LAYOUT && tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_ERROR) break;
                leftmostValid = tokenizer.getTokenAt(i + 1);
                ++i;
            }
            i = right.getIndex() + 1;
            while (i < tokenizer.getTokenCount()) {
                if (tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_EOF || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_ERROR) {
                    rightmostValid = tokenizer.getTokenAt(i);
                    ++i;
                    continue;
                }
                break;
            }
        } else if (isRightRecursive) {
            i = left.getIndex() - 1;
            while (i >= 0) {
                if (tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_LAYOUT && tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_ERROR) break;
                leftmostValid = tokenizer.getTokenAt(i);
                --i;
            }
            i = right.getIndex();
            while (i > left.getIndex()) {
                if (tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_EOF || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_ERROR) {
                    rightmostValid = tokenizer.getTokenAt(i - 1);
                    --i;
                    continue;
                }
                break;
            }
        } else {
            i = left.getIndex();
            while (i < right.getIndex()) {
                if (tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_LAYOUT && tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_ERROR) break;
                leftmostValid = tokenizer.getTokenAt(i + 1);
                ++i;
            }
            i = right.getIndex();
            while (i > left.getIndex()) {
                if (tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_LAYOUT || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_EOF || tokenizer.getTokenAt(i).getKind() == IToken.Kind.TK_ERROR) {
                    rightmostValid = tokenizer.getTokenAt(i - 1);
                    --i;
                    continue;
                }
                break;
            }
        }
        ISourceRegion region = JSGLRSourceRegionFactory.fromTokensLayout(leftmostValid, rightmostValid, isOptional || isList || isLeftRecursive || isRightRecursive);
        return new SourceLocation(region, resource);
    }

    private Collection<IStrategoTerm> findCompletionTerm(StrategoTerm ast) {
        final LinkedList<IStrategoTerm> completionTerms = new LinkedList<IStrategoTerm>();
        AStrategoTermVisitor visitor = new AStrategoTermVisitor(){

            @Override
            public boolean visit(IStrategoTerm term) {
                ImploderAttachment ia = term.getAttachment(ImploderAttachment.TYPE);
                if (ia.isNestedCompletion()) {
                    return false;
                }
                if (ia.isCompletion()) {
                    completionTerms.add(term);
                    return false;
                }
                return true;
            }
        };
        StrategoTermVisitee.topdown(visitor, ast);
        return completionTerms;
    }

    private Collection<IStrategoTerm> findPlaceholderTerms(IStrategoTerm ast) {
        final LinkedList<IStrategoTerm> placeholderTerms = new LinkedList<IStrategoTerm>();
        AStrategoTermVisitor visitor = new AStrategoTermVisitor(){

            @Override
            public boolean visit(IStrategoTerm term) {
                IStrategoAppl appl;
                if (TermUtils.isAppl(term) && (appl = (IStrategoAppl)term).getConstructor().getName().contains("-Plhdr") && appl.getSubtermCount() > 0) {
                    placeholderTerms.add(appl);
                    return false;
                }
                return true;
            }
        };
        StrategoTermVisitee.topdown(visitor, ast);
        return placeholderTerms;
    }

    private Collection<IStrategoTerm> findCompletionTermInsideNested(final IStrategoTerm ast) {
        final LinkedList<IStrategoTerm> completionTerms = new LinkedList<IStrategoTerm>();
        AStrategoTermVisitor visitor = new AStrategoTermVisitor(){

            @Override
            public boolean visit(IStrategoTerm term) {
                ImploderAttachment ia = term.getAttachment(ImploderAttachment.TYPE);
                if (ia.isNestedCompletion() && !term.equals(ast)) {
                    return false;
                }
                if (ia.isCompletion()) {
                    completionTerms.add(term);
                    return false;
                }
                return true;
            }
        };
        StrategoTermVisitee.topdown(visitor, ast);
        return completionTerms;
    }

    private Collection<IStrategoTerm> findNestedCompletionTerm(final IStrategoTerm ast, final boolean excludeIdTerm) {
        final LinkedList<IStrategoTerm> completionTerms = new LinkedList<IStrategoTerm>();
        AStrategoTermVisitor visitor = new AStrategoTermVisitor(){

            @Override
            public boolean visit(IStrategoTerm term) {
                ImploderAttachment ia = term.getAttachment(ImploderAttachment.TYPE);
                if (excludeIdTerm && term.equals(ast)) {
                    return true;
                }
                if (ia.isNestedCompletion()) {
                    completionTerms.add(term);
                    return false;
                }
                return true;
            }
        };
        StrategoTermVisitee.topdown(visitor, ast);
        return completionTerms;
    }

    private IStrategoTerm findTopMostAmbNode(IStrategoTerm newNode) {
        IStrategoTerm parent = ParentAttachment.getParent(newNode);
        if (parent == null) {
            return newNode;
        }
        if (ImploderAttachment.getSort(parent) == null) {
            return this.findTopMostAmbNode(parent);
        }
        return newNode;
    }

    private IStrategoTerm findTopMostCompletionNode(IStrategoTerm newNode) {
        IStrategoTerm parent = ParentAttachment.getParent(newNode);
        if (parent == null) {
            return newNode;
        }
        ImploderAttachment ia = ImploderAttachment.get(parent);
        if (ia.getSort() == null || ia.isNestedCompletion()) {
            return newNode;
        }
        return this.findTopMostCompletionNode(parent);
    }
}

