/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.sdf2table.grammar.IProduction;

public class TableSet
implements Serializable {
    private static final long serialVersionUID = 3001311608137161789L;
    IProduction p;
    ICharacterClass value;
    Set<TableSet> depends_on = new HashSet<TableSet>();
    Set<TableSet> dependents = new HashSet<TableSet>();
    int index = -1;
    int low_link = -1;
    boolean onStack = false;

    public TableSet(IProduction p) {
        this.p = p;
    }

    public void add(ICharacterClass cc) {
        if (this.value == null) {
            this.value = cc;
        } else if (cc != null) {
            this.value = cc.union(this.value);
        }
    }

    public void addDependency(TableSet s) {
        if (this.depends_on.add(s)) {
            s.addDependent(this);
        }
    }

    public void addDependent(TableSet s) {
        this.dependents.add(s);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableSet other = (TableSet)obj;
        return !(this.p == null ? other.p != null : !this.p.equals(other.p));
    }

    public String toString() {
        String buf = "";
        buf = String.valueOf(buf) + "prod: " + this.p + "\n";
        buf = this.value != null ? String.valueOf(buf) + "value = " + this.value + "\n" : String.valueOf(buf) + "no value\n";
        buf = String.valueOf(buf) + "depends on: ";
        if (this.depends_on.isEmpty()) {
            buf = String.valueOf(buf) + "---\n";
        }
        int i = 0;
        for (TableSet t : this.depends_on) {
            if (i != 0) {
                buf = String.valueOf(buf) + "            ";
            }
            buf = String.valueOf(buf) + t.p + "\n";
            ++i;
        }
        buf = String.valueOf(buf) + "dependents: ";
        i = 0;
        if (this.dependents.isEmpty()) {
            buf = String.valueOf(buf) + "---\n";
        }
        for (TableSet t : this.dependents) {
            if (i != 0) {
                buf = String.valueOf(buf) + "            ";
            }
            buf = String.valueOf(buf) + t.p + "\n";
            ++i;
        }
        return buf;
    }
}

