/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IGoto;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.query.ActionsForCharacterDisjointSorted;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.query.IActionsForCharacter;
import org.metaborg.parsetable.query.ParsingMode;
import org.metaborg.parsetable.states.IState;
import org.metaborg.sdf2table.grammar.CharacterClassSymbol;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.Accept;
import org.metaborg.sdf2table.parsetable.Action;
import org.metaborg.sdf2table.parsetable.Goto;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.ParseTableProduction;
import org.metaborg.sdf2table.parsetable.Reduce;
import org.metaborg.sdf2table.parsetable.ReduceLookahead;
import org.metaborg.sdf2table.parsetable.Shift;
import org.metaborg.sdf2table.parsetable.StateStatus;
import org.metaborg.util.collection.LinkedSetMultimap;
import org.metaborg.util.iterators.Iterables2;

public class State
implements IState,
Comparable<State>,
Serializable {
    private static final long serialVersionUID = 7118071460461287164L;
    ParseTable pt;
    private final int label;
    private final Set<Goto> gotos;
    private final Map<Integer, IGoto> gotosMapping;
    private final Set<LRItem> kernel;
    private final Set<LRItem> items;
    private final LinkedSetMultimap<Symbol, LRItem> symbol_items;
    private final LinkedSetMultimap<ICharacterClass, Action> lr_actions;
    IActionsForCharacter actionsForCharacter;
    private boolean rejectable = false;
    private StateStatus status = StateStatus.VISIBLE;

    public State(IProduction initialProduction, ParseTable pt) {
        this(Collections.singleton(new LRItem(initialProduction, 0, pt)), pt);
    }

    public State(Set<LRItem> kernel, ParseTable pt) {
        this.items = new LinkedHashSet<LRItem>();
        this.gotos = new LinkedHashSet<Goto>();
        this.gotosMapping = new HashMap<Integer, IGoto>();
        this.symbol_items = new LinkedSetMultimap();
        this.lr_actions = new LinkedSetMultimap();
        this.kernel = new LinkedHashSet<LRItem>();
        this.kernel.addAll(kernel);
        pt.kernelMap().put(kernel, this);
        this.pt = pt;
        this.label = this.pt.totalStates();
        this.pt.stateLabels().put(this.label, this);
        this.pt.incTotalStates();
    }

    public void closure() {
        for (LRItem item : this.kernel) {
            item.process(this.items, this.symbol_items, this);
        }
    }

    public void doShift() {
        for (Symbol s_at_dot : this.symbol_items.keySet()) {
            if (s_at_dot instanceof CharacterClassSymbol) {
                LinkedHashSet<LRItem> new_kernel = new LinkedHashSet<LRItem>();
                LinkedHashSet<Goto> new_gotos = new LinkedHashSet<Goto>();
                LinkedHashSet<Shift> new_shifts = new LinkedHashSet<Shift>();
                for (LRItem item : (Set)this.symbol_items.get(s_at_dot)) {
                    Shift shift = new Shift(((CharacterClassSymbol)s_at_dot).getCC());
                    new_kernel.add(item.shiftDot());
                    if (item.getProd().equals(this.pt.initialProduction()) && item.getDotPosition() == 1) continue;
                    new_shifts.add(shift);
                }
                if (new_kernel.isEmpty()) continue;
                this.checkKernel(new_kernel, new_gotos, new_shifts);
                continue;
            }
            for (IProduction p : (Set)this.pt.normalizedGrammar().getSymbolProductionsMapping().get(s_at_dot)) {
                if (this.pt.normalizedGrammar().getProdContextualProdMapping().get(p) != null) {
                    p = this.pt.normalizedGrammar().getProdContextualProdMapping().get(p);
                }
                LinkedHashSet<LRItem> new_kernel = new LinkedHashSet<LRItem>();
                LinkedHashSet<Goto> new_gotos = new LinkedHashSet<Goto>();
                LinkedHashSet<Shift> new_shifts = new LinkedHashSet<Shift>();
                for (LRItem item : (Set)this.symbol_items.get(s_at_dot)) {
                    if (item.isPriorityConflict(p)) continue;
                    new_kernel.add(item.shiftDot());
                    new_gotos.add(new Goto(this.pt.productionLabels().get(p), this.pt));
                }
                if (new_kernel.isEmpty()) continue;
                this.checkKernel(new_kernel, new_gotos, new_shifts);
            }
        }
    }

    public void doReduces() {
        for (LRItem item : this.items) {
            if (item.getDotPosition() == item.getProd().arity()) {
                int prod_label = this.pt.productionLabels().get(item.getProd());
                ISymbol leftHandSymbol = item.getProd().leftHand();
                ICharacterClass fr = leftHandSymbol.followRestriction();
                if ((fr == null || fr.isEmpty()) && leftHandSymbol.followRestrictionLookahead() == null) {
                    this.addReduceAction(item.getProd(), prod_label, CharacterClassFactory.FULL_RANGE, null);
                } else {
                    ICharacterClass final_range = CharacterClassFactory.FULL_RANGE;
                    if (fr != null && !fr.isEmpty()) {
                        final_range = final_range.difference(leftHandSymbol.followRestriction());
                    }
                    for (ICharacterClass[] s : leftHandSymbol.followRestrictionLookahead()) {
                        final_range = final_range.difference(s[0]);
                        ICharacterClass[] lookahead = Arrays.copyOfRange(s, 1, s.length);
                        this.addReduceAction(item.getProd(), prod_label, s[0], lookahead);
                    }
                    this.addReduceAction(item.getProd(), prod_label, final_range, null);
                }
            }
            if (!item.getProd().equals(this.pt.initialProduction()) || item.getDotPosition() != 1) continue;
            this.lr_actions.put(CharacterClassFactory.EOF_SINGLETON, new Accept(CharacterClassFactory.EOF_SINGLETON));
        }
    }

    private void addReduceAction(IProduction p, Integer label, ICharacterClass cc, ICharacterClass[] lookahead) {
        ICharacterClass final_range = cc;
        ParseTableProduction prod = this.pt.productionsMapping().get(p);
        LinkedSetMultimap<ICharacterClass, Reduce> newLR_actions = new LinkedSetMultimap<ICharacterClass, Reduce>();
        for (ICharacterClass range : this.lr_actions.keySet()) {
            if (final_range.isEmpty()) break;
            ICharacterClass intersection = final_range.intersection(range);
            if (intersection.isEmpty() || !intersection.equals(range)) continue;
            if (lookahead != null) {
                newLR_actions.put(intersection, new ReduceLookahead(prod, label, intersection, lookahead));
            } else {
                newLR_actions.put(intersection, new Reduce(prod, label, intersection));
            }
            final_range = final_range.difference(intersection);
        }
        this.lr_actions.putAll(newLR_actions);
        if (!final_range.isEmpty()) {
            if (lookahead != null) {
                this.lr_actions.put(final_range, new ReduceLookahead(prod, label, final_range, lookahead));
            } else {
                this.lr_actions.put(final_range, new Reduce(prod, label, final_range));
            }
        }
    }

    private void checkKernel(Set<LRItem> new_kernel, Set<Goto> new_gotos, Set<Shift> new_shifts) {
        if (this.pt.kernelMap().containsKey(new_kernel)) {
            int stateNumber = this.pt.kernelMap().get(new_kernel).getLabel();
            for (Shift shift : new_shifts) {
                shift.setState(stateNumber);
                this.lr_actions.put(shift.cc, shift);
            }
            for (Goto g : new_gotos) {
                g.setState(stateNumber);
                this.gotos.add(g);
                this.gotosMapping.put(g.label, g);
            }
        } else {
            State new_state = new State(new_kernel, this.pt);
            for (Shift shift : new_shifts) {
                shift.setState(new_state.getLabel());
                this.lr_actions.put(shift.cc, shift);
            }
            for (Goto g : new_gotos) {
                g.setState(new_state.getLabel());
                this.gotos.add(g);
                this.gotosMapping.put(g.label, g);
            }
            this.pt.stateQueue().add(new_state);
        }
    }

    public String toString() {
        String buf = "";
        int i = 0;
        buf = String.valueOf(buf) + "State " + this.getLabel();
        if (!this.gotos.isEmpty()) {
            buf = String.valueOf(buf) + "\nGotos: ";
        }
        for (IGoto iGoto : this.gotos) {
            if (i != 0) {
                buf = String.valueOf(buf) + "\n     , ";
            }
            buf = String.valueOf(buf) + iGoto;
            ++i;
        }
        if (!this.lr_actions.isEmpty()) {
            buf = String.valueOf(buf) + "\nActions: ";
        }
        i = 0;
        for (ICharacterClass iCharacterClass : this.lr_actions.keySet()) {
            if (i != 0) {
                buf = String.valueOf(buf) + "\n       , ";
            }
            buf = String.valueOf(buf) + iCharacterClass + ": ";
            int j = 0;
            for (IAction a : (Set)this.lr_actions.get(iCharacterClass)) {
                if (j != 0) {
                    buf = String.valueOf(buf) + ", ";
                }
                buf = String.valueOf(buf) + a;
                ++j;
            }
            ++i;
        }
        if (!this.items.isEmpty()) {
            buf = String.valueOf(buf) + "\nItems: ";
            i = 0;
            for (LRItem lRItem : this.items) {
                if (i != 0) {
                    buf = String.valueOf(buf) + "\n       ";
                }
                buf = String.valueOf(buf) + lRItem.toString();
                ++i;
            }
        } else {
            buf = String.valueOf(buf) + "\nItems: ";
            i = 0;
            for (LRItem lRItem : this.kernel) {
                if (i != 0) {
                    buf = String.valueOf(buf) + "\n       ";
                }
                buf = String.valueOf(buf) + lRItem.toString();
                ++i;
            }
        }
        return buf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kernel == null ? 0 : this.kernel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        return !(this.kernel == null ? other.kernel != null : !this.kernel.equals(other.kernel));
    }

    @Override
    public int compareTo(State o) {
        return this.getLabel() - o.getLabel();
    }

    public int getLabel() {
        return this.label;
    }

    public Set<LRItem> getKernel() {
        return this.kernel;
    }

    public Set<LRItem> getItems() {
        return this.items;
    }

    public StateStatus status() {
        return this.status;
    }

    public void setStatus(StateStatus status) {
        this.status = status;
    }

    public void markDirty() {
        this.items.clear();
        this.symbol_items.clear();
        this.lr_actions.clear();
        this.setStatus(StateStatus.DIRTY);
    }

    public Set<Goto> gotos() {
        return this.gotos;
    }

    public Iterable<Action> actions() {
        HashSet<Action> actions = Iterables2.toHashSet(this.lr_actions.values());
        return actions;
    }

    public LinkedSetMultimap<ICharacterClass, Action> actionsMapping() {
        return this.lr_actions;
    }

    @Override
    public boolean isRejectable() {
        return this.rejectable;
    }

    public void markRejectable() {
        this.rejectable = true;
    }

    @Override
    public int id() {
        return this.label;
    }

    @Override
    public Iterable<IAction> getApplicableActions(IActionQuery actionQuery, ParsingMode parsingMode) {
        return this.actionsForCharacter.getApplicableActions(actionQuery, parsingMode);
    }

    @Override
    public Iterable<IReduce> getApplicableReduceActions(IActionQuery actionQuery, ParsingMode parsingMode) {
        return this.actionsForCharacter.getApplicableReduceActions(actionQuery, parsingMode);
    }

    @Override
    public int getGotoId(int productionId) {
        return this.gotosMapping.get(productionId).gotoStateId();
    }

    @Override
    public int getGotoId(int productionId, int defaultValue) {
        IGoto iGoto = this.gotosMapping.get(productionId);
        return iGoto == null ? defaultValue : iGoto.gotoStateId();
    }

    public void calculateActionsForCharacter() {
        this.actionsForCharacter = new ActionsForCharacterDisjointSorted(this.readActions(), Collections.emptySet());
    }

    private ActionsPerCharacterClass[] readActions() {
        Set characterClasses = this.lr_actions.keySet();
        ActionsPerCharacterClass[] actionsPerCharacterClasses = new ActionsPerCharacterClass[characterClasses.size()];
        int i = 0;
        for (ICharacterClass cc : characterClasses) {
            actionsPerCharacterClasses[i++] = new ActionsPerCharacterClass(cc, ((Set)this.lr_actions.get(cc)).toArray(new IAction[0]));
        }
        return actionsPerCharacterClasses;
    }
}

