/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import java.util.BitSet;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.characterclasses.ICharacterClassFactory;
import org.metaborg.sdf2table.grammar.CharacterClass;

public class CharacterClassFactory
implements ICharacterClassFactory,
Serializable {
    private static final long serialVersionUID = -73296884457025056L;
    public static final ICharacterClass EMPTY_CHARACTER_CLASS = new CharacterClass(new BitSet(), false);
    public static final ICharacterClass FULL_RANGE = CharacterClassFactory.fullRangeCC();
    public static final ICharacterClass EOF_SINGLETON = CharacterClassFactory.eofCC();

    @Override
    public ICharacterClass fromEmpty() {
        return new CharacterClass(new BitSet(), false);
    }

    @Override
    public ICharacterClass fromSingle(int character) {
        if (character == -1) {
            return EOF_SINGLETON;
        }
        BitSet chars = new BitSet(0x110000);
        chars.set(character);
        return new CharacterClass(chars, false);
    }

    @Override
    public ICharacterClass fromRange(int from, int to) {
        BitSet chars = new BitSet(0x110000);
        chars.set(from, to + 1);
        return new CharacterClass(chars, false);
    }

    @Override
    public ICharacterClass fromRanges(int[] ranges, boolean hasEOF) {
        BitSet chars = new BitSet(0x110000);
        int i = 0;
        while (i < ranges.length) {
            chars.set(ranges[i], ranges[i + 1] + 1);
            ++i;
        }
        return new CharacterClass(chars, hasEOF);
    }

    @Override
    public ICharacterClass finalize(ICharacterClass characterClass) {
        return characterClass;
    }

    private static ICharacterClass fullRangeCC() {
        BitSet chars = new BitSet(0x110000);
        chars.set(0, 0x110000);
        return new CharacterClass(chars, true);
    }

    private static ICharacterClass eofCC() {
        return new CharacterClass(new BitSet(), true);
    }
}

