/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import java.io.Serializable;
import java.util.Map;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;

public final class Context
implements Serializable {
    private static final long serialVersionUID = -4581589940398341265L;
    private final int context;
    private final ContextType type;
    private final ContextPosition position;
    private final long contextBitmap;

    public Context(int context, ContextType type, ContextPosition position, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        this.context = context;
        this.type = type;
        this.position = position;
        if (position == ContextPosition.LEFTMOST && leftmostContextsMapping.containsKey(context)) {
            this.contextBitmap = 1L << leftmostContextsMapping.get(context);
        } else if (position == ContextPosition.RIGHTMOST && rightmostContextsMapping.containsKey(context)) {
            int offset = leftmostContextsMapping.keySet().size();
            this.contextBitmap = 1L << rightmostContextsMapping.get(context) + offset;
        } else {
            this.contextBitmap = 0L;
        }
    }

    public String toString() {
        return "" + this.context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.context;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        if (this.context != other.context) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        return this.type == other.type;
    }

    public ContextType getType() {
        return this.type;
    }

    public ContextPosition getPosition() {
        return this.position;
    }

    public int getContext() {
        return this.context;
    }

    public long getContextBitmap() {
        return this.contextBitmap;
    }
}

