/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.query.IActionQuery;

public class ActionsForRange
implements Serializable {
    private static final long serialVersionUID = -1143306908480814413L;
    public final IAction[] actions;
    public final int from;
    public final int to;

    public ActionsForRange(IAction[] actions, int from, int to) {
        this.actions = actions;
        this.from = from;
        this.to = to;
    }

    public final Iterable<IAction> getApplicableActions(final IActionQuery actionQuery) {
        return () -> new Iterator<IAction>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < ActionsForRange.this.actions.length && !ActionsForRange.this.actions[this.index].allowsLookahead(actionQuery)) {
                    ++this.index;
                }
                return this.index < ActionsForRange.this.actions.length;
            }

            @Override
            public IAction next() {
                return ActionsForRange.this.actions[this.index++];
            }
        };
    }

    public final Iterable<IReduce> getApplicableReduceActions(final IActionQuery actionQuery) {
        return () -> new Iterator<IReduce>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < ActionsForRange.this.actions.length && !ActionsForRange.this.actions[this.index].isApplicableReduce(actionQuery)) {
                    ++this.index;
                }
                return this.index < ActionsForRange.this.actions.length;
            }

            @Override
            public IReduce next() {
                return (IReduce)ActionsForRange.this.actions[this.index++];
            }
        };
    }

    public String toString() {
        return "{" + CharacterClassFactory.intToString(this.from) + "," + CharacterClassFactory.intToString(this.to) + "}->" + Arrays.toString(this.actions);
    }
}

