/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.productions;

import mb.jsglr.shared.IToken;
import org.metaborg.parsetable.symbols.ConcreteSyntaxContext;
import org.metaborg.parsetable.symbols.ISymbol;

public interface IProduction {
    public int id();

    public ISymbol lhs();

    public String sort();

    public String startSymbolSort();

    public String constructor();

    public static boolean isListConstructor(String constructor) {
        return "Snoc".equals(constructor) || "Ins".equals(constructor) || "Nil".equals(constructor);
    }

    public String descriptor();

    public ConcreteSyntaxContext concreteSyntaxContext();

    default public boolean isContextFree() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.ContextFree;
    }

    default public boolean isLayout() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Layout;
    }

    default public boolean isLiteral() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Literal;
    }

    default public boolean isLexical() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Lexical;
    }

    default public boolean isSkippableInParseForest() {
        return !this.isContextFree();
    }

    public boolean isList();

    public boolean isOptional();

    public boolean isRecovery();

    default public boolean isWater() {
        return this.sort() != null && this.sort().contains("WATER") || "WATER".equals(this.constructor());
    }

    default public boolean isInsertion() {
        return "INSERTION".equals(this.constructor());
    }

    public boolean isCompletion();

    public boolean isStringLiteral();

    public boolean isNumberLiteral();

    public boolean isOperator();

    public boolean isIgnoreLayoutConstraint();

    public boolean isLongestMatch();

    public boolean isBracket();

    public boolean isNonAssocWith(IProduction var1);

    public boolean isNonNestedWith(IProduction var1);

    public static IToken.Kind getTokenKind(IProduction production) {
        if (production == null) {
            return IToken.Kind.TK_STRING;
        }
        if (production.isLayout()) {
            return IToken.Kind.TK_LAYOUT;
        }
        if (production.isLiteral()) {
            if (production.isOperator()) {
                return IToken.Kind.TK_OPERATOR;
            }
            return IToken.Kind.TK_KEYWORD;
        }
        if (production.isLexical()) {
            if (production.isStringLiteral()) {
                return IToken.Kind.TK_STRING;
            }
            if (production.isNumberLiteral()) {
                return IToken.Kind.TK_NUMBER;
            }
            return IToken.Kind.TK_IDENTIFIER;
        }
        throw new IllegalStateException("invalid production/token type");
    }
}

