/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageUtils {
    private static final ILogger logger = LoggerUtils.logger(LanguageUtils.class);

    public static Set<ILanguageImpl> toImpls(Iterable<? extends ILanguageComponent> components) {
        HashSet<ILanguageImpl> impls = new HashSet<ILanguageImpl>();
        for (ILanguageComponent iLanguageComponent : components) {
            Iterables2.addAll(impls, iLanguageComponent.contributesTo());
        }
        return impls;
    }

    public static Set<ILanguageComponent> toComponents(Iterable<? extends ILanguageImpl> impls) {
        HashSet<ILanguageComponent> components = new HashSet<ILanguageComponent>();
        for (ILanguageImpl iLanguageImpl : impls) {
            Iterables2.addAll(components, iLanguageImpl.components());
        }
        return components;
    }

    @Nullable
    public static ILanguageImpl active(Iterable<? extends ILanguageImpl> impls) {
        ILanguageImpl active = null;
        for (ILanguageImpl iLanguageImpl : impls) {
            if (active != null && !LanguageUtils.isGreater(iLanguageImpl, active)) continue;
            active = iLanguageImpl;
        }
        return active;
    }

    public static Iterable<ILanguageImpl> allActiveImpls(ILanguageService languageService) {
        Iterable<? extends ILanguage> languages = languageService.getAllLanguages();
        LinkedList<ILanguageImpl> activeImpls = new LinkedList<ILanguageImpl>();
        for (ILanguage iLanguage : languages) {
            ILanguageImpl impl = iLanguage.activeImpl();
            if (impl == null) {
                logger.debug("Unexpected null for active implementation of language {}, skipping in active language implementations", iLanguage);
                continue;
            }
            activeImpls.add(impl);
        }
        return activeImpls;
    }

    public static Iterable<ILanguageComponent> allActiveComponents(ILanguageService languageService) {
        Iterable<ILanguageImpl> activeImpls = LanguageUtils.allActiveImpls(languageService);
        LinkedList<ILanguageComponent> activeComponents = new LinkedList<ILanguageComponent>();
        for (ILanguageImpl impl : activeImpls) {
            Iterables2.addAll(activeComponents, impl.components());
        }
        return activeComponents;
    }

    private static boolean isGreater(ILanguageImpl impl, ILanguageImpl other) {
        int compareVersion = impl.id().version.compareTo(other.id().version);
        return compareVersion > 0 || compareVersion == 0 && impl.sequenceId() > other.sequenceId();
    }
}

