/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IGenerateConfig;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageImplConfig;
import org.metaborg.core.language.LanguageIdentifier;

public class LanguageImplConfig
implements ILanguageImplConfig {
    private final Set<LanguageIdentifier> compileDeps = new HashSet<LanguageIdentifier>();
    private final Set<LanguageIdentifier> sourceDeps = new HashSet<LanguageIdentifier>();
    private final Set<LanguageIdentifier> javaDeps = new HashSet<LanguageIdentifier>();
    private final Collection<IGenerateConfig> generates = new ArrayList<IGenerateConfig>();
    private final Collection<IExportConfig> exports = new ArrayList<IExportConfig>();

    public LanguageImplConfig(Iterable<ILanguageComponentConfig> configs) {
        for (ILanguageComponentConfig config : configs) {
            this.compileDeps.addAll(config.compileDeps());
            this.sourceDeps.addAll(config.sourceDeps());
            this.javaDeps.addAll(config.javaDeps());
            this.generates.addAll(config.generates());
            this.exports.addAll(config.exports());
        }
    }

    @Override
    public Iterable<LanguageIdentifier> compileDeps() {
        return this.compileDeps;
    }

    @Override
    public Iterable<LanguageIdentifier> sourceDeps() {
        return this.sourceDeps;
    }

    @Override
    public Iterable<LanguageIdentifier> javaDeps() {
        return this.javaDeps;
    }

    @Override
    public Iterable<IGenerateConfig> generates() {
        return this.generates;
    }

    @Override
    public Iterable<IExportConfig> exports() {
        return this.exports;
    }
}

