/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.virtlink.commons.configuration2.jackson.JacksonConfiguration;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.config.PathLookup;

public abstract class AConfigurationReaderWriter {
    private static final Charset DefaultCharset = StandardCharsets.UTF_8;

    public HierarchicalConfiguration<ImmutableNode> read(FileObject source, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = source.getContent().getInputStream();){
            return this.read(input, rootFolder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public HierarchicalConfiguration<ImmutableNode> read(InputStream input, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, DefaultCharset));){
            return this.read(reader, rootFolder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public HierarchicalConfiguration<ImmutableNode> read(Reader reader, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        JacksonConfiguration resultConfig = this.create(null, rootFolder);
        resultConfig.read(reader);
        return resultConfig;
    }

    public void write(HierarchicalConfiguration<ImmutableNode> configuration, FileObject destination, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream output = destination.getContent().getOutputStream();){
            this.write(configuration, output, rootFolder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(HierarchicalConfiguration<ImmutableNode> configuration, OutputStream output, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(output, DefaultCharset);){
            this.write(configuration, writer, rootFolder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(HierarchicalConfiguration<ImmutableNode> configuration, Writer writer, @Nullable FileObject rootFolder) throws IOException, ConfigurationException {
        JacksonConfiguration resultConfig = this.create(configuration, rootFolder);
        resultConfig.write(writer);
    }

    public JacksonConfiguration create(@Nullable HierarchicalConfiguration<ImmutableNode> source, @Nullable FileObject rootFolder) {
        JacksonConfiguration config = this.createNew(source);
        if (rootFolder != null) {
            config.getInterpolator().registerLookup("path", (Lookup)new PathLookup(rootFolder));
        }
        return config;
    }

    public JacksonConfiguration create() {
        return this.createNew(null);
    }

    protected abstract JacksonConfiguration createNew(@Nullable HierarchicalConfiguration<ImmutableNode> var1);
}

