/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.paths;

import java.util.ArrayList;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.build.paths.ILanguagePathProvider;
import org.metaborg.core.config.ISourceConfig;
import org.metaborg.core.config.ISourceVisitor;
import org.metaborg.core.project.IProject;
import org.metaborg.util.iterators.Iterables2;

public class SourcePathProvider
implements ILanguagePathProvider {
    @Override
    public Iterable<FileObject> sourcePaths(IProject project, String languageName) {
        ArrayList<FileObject> sources = new ArrayList<FileObject>();
        for (ISourceConfig source : project.config().sources()) {
            source.accept(ISourceVisitor.of(langSource -> {
                if (langSource.language.equals(languageName)) {
                    sources.add(this.resolve(project.location(), langSource.directory));
                }
            }, allLangSource -> sources.add(this.resolve(project.location(), allLangSource.directory))));
        }
        return sources;
    }

    @Override
    public Iterable<FileObject> includePaths(IProject project, String languageName) {
        return Iterables2.empty();
    }

    private FileObject resolve(FileObject baseDir, String path) {
        try {
            return ResourceUtils.resolveFile(baseDir, path);
        }
        catch (FileSystemException ex) {
            throw new MetaborgRuntimeException(ex);
        }
    }
}

