/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.build.BuildInput;
import org.metaborg.core.build.BuildOrder;
import org.metaborg.core.build.BuildState;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.core.messages.IMessagePrinter;
import org.metaborg.core.project.IProject;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.iterators.Iterables2;

public class BuildInputBuilder {
    private final IProject project;
    private BuildState state;
    private Set<ILanguageImpl> languages;
    private boolean addDependencyLanguages;
    private SetMultimap<ILanguageImpl, FileObject> includePaths;
    private boolean addDefaultIncludePaths;
    private Collection<ResourceChange> sourceChanges;
    private boolean addSourcesFromDefaultSourceLocations;
    @Nullable
    private FileSelector selector;
    private boolean analyze;
    @Nullable
    private FileSelector analyzeSelector;
    private boolean transform;
    @Nullable
    private FileSelector transformSelector;
    private Collection<ITransformGoal> transformGoals;
    @Nullable
    private IMessagePrinter messagePrinter;
    private boolean throwOnErrors;
    private Set<ILanguageImpl> pardonedLanguages;
    private Set<String> pardonedLanguageStrings;

    @Inject
    public BuildInputBuilder(IProject project) {
        this.project = project;
        this.reset();
    }

    public BuildInputBuilder reset() {
        this.state = null;
        this.languages = new HashSet<ILanguageImpl>();
        this.addDependencyLanguages = true;
        this.includePaths = new SetMultimap();
        this.addDefaultIncludePaths = true;
        this.sourceChanges = new LinkedList<ResourceChange>();
        this.addSourcesFromDefaultSourceLocations = false;
        this.selector = null;
        this.analyze = true;
        this.analyzeSelector = null;
        this.transform = true;
        this.transformSelector = null;
        this.transformGoals = new LinkedList<ITransformGoal>();
        this.messagePrinter = null;
        this.throwOnErrors = false;
        this.pardonedLanguages = new HashSet<ILanguageImpl>();
        this.pardonedLanguageStrings = new HashSet<String>();
        return this;
    }

    public BuildInputBuilder withState(@Nullable BuildState state) {
        this.state = state;
        return this;
    }

    public BuildInputBuilder withLanguages(Set<ILanguageImpl> languages) {
        this.languages = languages;
        return this;
    }

    public BuildInputBuilder withLanguages(Collection<ILanguageImpl> languages) {
        this.languages = new HashSet<ILanguageImpl>(languages);
        return this;
    }

    public BuildInputBuilder addLanguages(Iterable<? extends ILanguageImpl> languages) {
        Iterables2.addAll(this.languages, languages);
        return this;
    }

    public BuildInputBuilder addLanguage(ILanguageImpl language) {
        this.languages.add(language);
        return this;
    }

    public BuildInputBuilder withComponents(Iterable<ILanguageComponent> components) {
        this.withLanguages(LanguageUtils.toImpls(components));
        return this;
    }

    public BuildInputBuilder addComponents(Iterable<? extends ILanguageComponent> components) {
        this.addLanguages(LanguageUtils.toImpls(components));
        return this;
    }

    public BuildInputBuilder addComponent(ILanguageComponent component) {
        this.addLanguages(component.contributesTo());
        return this;
    }

    public BuildInputBuilder withCompileDependencyLanguages(boolean addDependencyLanguages) {
        this.addDependencyLanguages = addDependencyLanguages;
        return this;
    }

    public BuildInputBuilder withSourceChanges(Collection<ResourceChange> sourceChanges) {
        this.sourceChanges = sourceChanges;
        return this;
    }

    public BuildInputBuilder withSourceChanges(Iterable<ResourceChange> sourceChanges) {
        this.sourceChanges = Iterables2.toArrayList(sourceChanges);
        return this;
    }

    public BuildInputBuilder addSourceChanges(Iterable<ResourceChange> sourceChanges) {
        Iterables2.addAll(this.sourceChanges, sourceChanges);
        return this;
    }

    public BuildInputBuilder withSources(Iterable<FileObject> sources) {
        this.sourceChanges = new LinkedList<ResourceChange>();
        return this.addSources(sources);
    }

    public BuildInputBuilder addIdentifiedSources(Iterable<IdentifiedResource> sources) {
        for (IdentifiedResource source : sources) {
            this.addSource(source);
        }
        return this;
    }

    public BuildInputBuilder addSources(Iterable<FileObject> sources) {
        for (FileObject source : sources) {
            this.addSource(source);
        }
        return this;
    }

    public BuildInputBuilder addSource(IdentifiedResource source) {
        this.sourceChanges.add(new ResourceChange(source.resource));
        return this;
    }

    public BuildInputBuilder addSource(FileObject source) {
        this.sourceChanges.add(new ResourceChange(source));
        return this;
    }

    public BuildInputBuilder addSourcesFromSourceLocations(Iterable<FileObject> sourceLocations) {
        this.addSources(ResourceUtils.expand(sourceLocations));
        return this;
    }

    public BuildInputBuilder withSourcesFromDefaultSourceLocations(boolean addSourcesFromDefaultSourceLocations) {
        this.addSourcesFromDefaultSourceLocations = addSourcesFromDefaultSourceLocations;
        return this;
    }

    public BuildInputBuilder addIncludePaths(ILanguageImpl language, Iterable<FileObject> includePaths) {
        for (FileObject includePath : includePaths) {
            this.includePaths.put(language, includePath);
        }
        return this;
    }

    public BuildInputBuilder withDefaultIncludePaths(boolean addDefaultIncludePaths) {
        this.addDefaultIncludePaths = addDefaultIncludePaths;
        return this;
    }

    public BuildInputBuilder withSelector(FileSelector selector) {
        this.selector = selector;
        return this;
    }

    public BuildInputBuilder withAnalysis(boolean analyze) {
        this.analyze = analyze;
        return this;
    }

    public BuildInputBuilder withAnalyzeSelector(FileSelector analyzeSelector) {
        this.analyzeSelector = analyzeSelector;
        return this;
    }

    public BuildInputBuilder withTransformation(boolean transform) {
        this.transform = transform;
        return this;
    }

    public BuildInputBuilder withTransformSelector(FileSelector transformSelector) {
        this.transformSelector = transformSelector;
        return this;
    }

    public BuildInputBuilder withTransformGoals(Collection<ITransformGoal> transformGoals) {
        this.transformGoals = transformGoals;
        return this;
    }

    public BuildInputBuilder addTransformGoal(ITransformGoal goal) {
        this.transformGoals.add(goal);
        return this;
    }

    public BuildInputBuilder withMessagePrinter(IMessagePrinter messagePrinter) {
        this.messagePrinter = messagePrinter;
        return this;
    }

    public BuildInputBuilder withThrowOnErrors(boolean throwOnErrors) {
        this.throwOnErrors = throwOnErrors;
        return this;
    }

    public BuildInputBuilder withPardonedLanguages(Set<ILanguageImpl> pardonedLanguages) {
        this.pardonedLanguages = pardonedLanguages;
        return this;
    }

    public BuildInputBuilder withPardonedLanguageStrings(Collection<String> pardonedLanguages) {
        this.pardonedLanguageStrings = new HashSet<String>(pardonedLanguages);
        return this;
    }

    public BuildInputBuilder addPardonedLanguage(ILanguageImpl pardonedLanguage) {
        this.pardonedLanguages.add(pardonedLanguage);
        return this;
    }

    public BuildInputBuilder addPardonedLanguageString(String pardonedLanguage) {
        this.pardonedLanguageStrings.add(pardonedLanguage);
        return this;
    }

    public BuildInput build(IDependencyService dependencyService, ILanguagePathService languagePathService) throws MetaborgException {
        if (this.state == null) {
            this.state = new BuildState();
        }
        if (this.addDependencyLanguages) {
            Collection<ILanguageComponent> compileComponents = dependencyService.compileDeps(this.project);
            Set<ILanguageImpl> compileImpls = LanguageUtils.toImpls(compileComponents);
            this.addLanguages(compileImpls);
        }
        if (this.addDefaultIncludePaths) {
            for (ILanguageImpl language : this.languages) {
                this.addIncludePaths(language, languagePathService.includePaths(this.project, language.belongsTo().name()));
            }
        }
        if (this.addSourcesFromDefaultSourceLocations) {
            for (ILanguageImpl language : this.languages) {
                Iterable<IdentifiedResource> sources = languagePathService.sourceFiles(this.project, language);
                this.addIdentifiedSources(sources);
            }
        }
        for (ILanguageImpl language : this.languages) {
            if (!this.pardonedLanguageStrings.contains(language.belongsTo().name())) continue;
            this.addPardonedLanguage(language);
        }
        return new BuildInput(this.state, this.project, this.sourceChanges, this.includePaths, new BuildOrder(this.languages), this.selector, this.analyze, this.analyzeSelector, this.transform, this.transformSelector, this.transformGoals, this.messagePrinter, this.throwOnErrors, this.pardonedLanguages);
    }
}

