/*
 * Decompiled with CFR 0.152.
 */
package mb.util.vfs2.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import mb.util.vfs2.resource.AndFileSelector;
import mb.util.vfs2.resource.AntPatternFileSelector;
import mb.util.vfs2.resource.ContainsFileSelector;
import mb.util.vfs2.resource.DefaultFileSelectInfo;
import mb.util.vfs2.resource.EndsWithFileSelector;
import mb.util.vfs2.resource.ExtensionFileSelector;
import mb.util.vfs2.resource.IncludeExcludeFileSelector;
import mb.util.vfs2.resource.IncludesExcludesFileSelector;
import mb.util.vfs2.resource.NoneFileSelector;
import mb.util.vfs2.resource.NotFileSelector;
import mb.util.vfs2.resource.OrFileSelector;
import mb.util.vfs2.resource.PatternFileSelector;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.metaborg.util.iterators.Iterables2;

public class FileSelectorUtils {
    public static FileSelector all() {
        return new AllFileSelector();
    }

    public static FileSelector none() {
        return new NoneFileSelector();
    }

    public static FileSelector contains(String contains) {
        return new ContainsFileSelector(contains);
    }

    public static FileSelector endsWith(String endsWith) {
        return new EndsWithFileSelector(endsWith);
    }

    public static FileSelector extensions(Collection<String> extensions) {
        return new ExtensionFileSelector(extensions);
    }

    public static FileSelector extensions(String ... extensions) {
        return new ExtensionFileSelector(Arrays.asList(extensions));
    }

    public static FileSelector extension(String extension) {
        return new ExtensionFileSelector(extension);
    }

    public static FileSelector regex(String regex) {
        return new PatternFileSelector(regex);
    }

    public static FileSelector regex(String regex, int flags) {
        return new PatternFileSelector(regex, flags);
    }

    public static FileSelector regex(Pattern pattern) {
        return new PatternFileSelector(pattern);
    }

    public static FileSelector ant(String pattern) {
        return new AntPatternFileSelector(pattern);
    }

    public static FileSelector ant(String pattern, FileType fileType) {
        return new AntPatternFileSelector(pattern, fileType);
    }

    public static FileSelector ant(Iterable<String> patterns) {
        return new AntPatternFileSelector(patterns);
    }

    public static FileSelector ant(String ... patterns) {
        return new AntPatternFileSelector(Iterables2.from(patterns));
    }

    public static FileSelector ant(Iterable<String> patterns, FileType fileType) {
        return new AntPatternFileSelector(patterns, fileType);
    }

    public static FileSelector and(Iterable<FileSelector> selectors) {
        return new AndFileSelector(selectors);
    }

    public static FileSelector and(FileSelector ... selectors) {
        return FileSelectorUtils.and(Iterables2.from(selectors));
    }

    public static FileSelector or(Iterable<FileSelector> selectors) {
        return new OrFileSelector(selectors);
    }

    public static FileSelector or(FileSelector ... selectors) {
        return FileSelectorUtils.or(Iterables2.from(selectors));
    }

    public static FileSelector not(FileSelector selector) {
        return new NotFileSelector(selector);
    }

    public static FileSelector includeExclude(FileSelector include, FileSelector exclude) {
        return new IncludeExcludeFileSelector(include, exclude);
    }

    public static FileSelector includesExcludes(Iterable<FileSelector> includes, Iterable<FileSelector> excludes) {
        return new IncludesExcludesFileSelector(includes, excludes);
    }

    public static FileSelectInfo info(FileObject file, FileObject base, int depth) {
        return new DefaultFileSelectInfo(base, file, depth);
    }

    public static FileSelectInfo info(FileObject file, FileObject base) {
        return FileSelectorUtils.info(base, file, -1);
    }

    public static FileSelectInfo info(FileObject file) throws FileSystemException {
        return FileSelectorUtils.info(file, file.getParent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean include(FileSelector selector, FileObject resource, FileObject base) throws FileSystemException {
        int depth = FileSelectorUtils.depth(resource, base);
        FileObject current = resource;
        FileSelectInfo info = FileSelectorUtils.info(current, base, depth);
        try {
            if (!selector.includeFile(info)) {
                return false;
            }
            if (depth == 0) {
                return FileSelectorUtils.includeOne(selector, resource, info);
            }
            while (true) {
                if (depth < 0) {
                    return true;
                }
                if (!FileSelectorUtils.includeOne(selector, current, info)) {
                    return false;
                }
                if ((current = current.getParent()) == null) {
                    throw new FileSystemException("vfs.provider/find-files.error", (Object)resource);
                }
                info = FileSelectorUtils.info(current, base, --depth);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/find-files.error", (Object)resource, (Throwable)e);
        }
    }

    public static boolean includeOne(FileSelector selector, FileObject resource, FileSelectInfo info) throws FileSystemException, Exception {
        switch (resource.getType()) {
            case FILE: {
                if (selector.includeFile(info)) break;
                return false;
            }
            case FOLDER: {
                if (selector.traverseDescendents(info)) break;
                return false;
            }
            case FILE_OR_FOLDER: 
            case IMAGINARY: {
                if (selector.includeFile(info) && selector.traverseDescendents(info)) break;
                return false;
            }
        }
        return true;
    }

    public static Iterable<FileObject> filter(FileSelector selector, Iterable<FileObject> resources, FileObject base) throws FileSystemException {
        LinkedList<FileObject> filteredResources = new LinkedList<FileObject>();
        for (FileObject resource : resources) {
            if (!FileSelectorUtils.include(selector, resource, base)) continue;
            filteredResources.add(resource);
        }
        return filteredResources;
    }

    private static int depth(FileObject resource, FileObject base) {
        int depth = 0;
        FileObject current = resource;
        while (!current.getName().equals(base.getName())) {
            ++depth;
            try {
                current = current.getParent();
            }
            catch (FileSystemException e) {
                throw new RuntimeException("Cannot calculate depth", e);
            }
            if (current != null) continue;
            throw new RuntimeException("Cannot calculate depth, resource is not part of base");
        }
        return depth;
    }

    public static boolean typeMatches(FileType type, FileType expectedType) {
        return type == expectedType || expectedType == FileType.FILE_OR_FOLDER && (type == FileType.FILE || type == FileType.FOLDER);
    }
}

