/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.IStatixProjectConfig;
import mb.statix.spoofax.StatixPrimitive;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_extract_messages
extends StatixPrimitive {
    @Inject
    public STX_extract_messages() {
        super(STX_extract_messages.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        IStatixProjectConfig config = STX_extract_messages.getConfig(term);
        SolverResult<?> result = STX_extract_messages.getResult(term);
        IUniDisunifier.Immutable unifier = result.state().unifier();
        ArrayList errorList = new ArrayList();
        ArrayList warningList = new ArrayList();
        ArrayList noteList = new ArrayList();
        result.messages().forEach((c, m) -> MessageUtil.addMessage(m, c, unifier, config, errorList, warningList, noteList));
        IListTerm errors = TermBuild.B.newList(errorList);
        IListTerm warnings = TermBuild.B.newList(warningList);
        IListTerm notes = TermBuild.B.newList(noteList);
        ITerm resultTerm = TermBuild.B.newTuple(errors, warnings, notes);
        return Optional.of(resultTerm);
    }
}

