/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.store;

import io.usethesource.capsule.Map;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import mb.nabl2.terms.ITermVar;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.log.IDebugContext;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.log.Level;

public class BaseConstraintStore
implements IConstraintStore {
    final IDebugContext debug;
    private final Deque<IConstraint> active;
    private final SetMultimap<ITermVar, Delayed> stuckOnVar;
    private final SetMultimap<CriticalEdge, Delayed> stuckOnEdge;

    public BaseConstraintStore(IDebugContext debug) {
        this.debug = debug;
        this.active = new ConcurrentLinkedDeque<IConstraint>();
        this.stuckOnVar = new SetMultimap();
        this.stuckOnEdge = new SetMultimap();
    }

    @Override
    public int activeSize() {
        return this.active.size();
    }

    @Override
    public int delayedSize() {
        return this.stuckOnVar.size() + this.stuckOnEdge.size();
    }

    @Override
    public void add(IConstraint constraint) {
        this.active.push(constraint);
    }

    @Override
    public IConstraint remove() throws NoSuchElementException {
        return this.active.poll();
    }

    @Override
    public void delay(IConstraint constraint, Delay delay) {
        Delayed delayed = new Delayed(constraint);
        if (!delay.vars().isEmpty()) {
            if (this.debug.isEnabled(Level.Debug)) {
                this.debug.debug("delayed {} on vars {}", constraint, delay.vars());
            }
            for (ITermVar var : delay.vars()) {
                this.stuckOnVar.put(var, delayed);
            }
        } else if (!delay.criticalEdges().isEmpty()) {
            if (this.debug.isEnabled(Level.Debug)) {
                this.debug.debug("delayed {} on critical edges {}", constraint, delay.criticalEdges());
            }
            for (CriticalEdge edge : delay.criticalEdges()) {
                this.stuckOnEdge.put(edge, delayed);
            }
        } else {
            throw new IllegalArgumentException("delayed for no apparent reason");
        }
    }

    @Override
    public void activateFromVars(Iterable<? extends ITermVar> vars, IDebugContext debug) {
        for (ITermVar iTermVar : vars) {
            Set<Delayed> activated = this.stuckOnVar.remove(iTermVar);
            for (Delayed delayed : activated) {
                if (!delayed.activate()) continue;
                IConstraint constraint = delayed.constraint;
                if (debug.isEnabled(Level.Debug)) {
                    debug.debug("activating {}", constraint);
                }
                this.add(constraint);
            }
        }
    }

    @Override
    public void activateFromEdges(Iterable<? extends CriticalEdge> edges, IDebugContext debug) {
        for (CriticalEdge criticalEdge : edges) {
            Set<Delayed> activated = this.stuckOnEdge.remove(criticalEdge);
            for (Delayed delayed : activated) {
                if (!delayed.activate()) continue;
                IConstraint constraint = delayed.constraint;
                if (debug.isEnabled(Level.Debug)) {
                    debug.debug("activating {}", constraint);
                }
                this.add(constraint);
            }
        }
    }

    @Override
    public Map.Immutable<IConstraint, Delay> delayed() {
        SetMultimap varStuck = new SetMultimap();
        this.stuckOnVar.entries().filter(e -> !((Delayed)e.getValue()).activated).forEach(e -> {
            boolean bl = varStuck.put(((Delayed)e.getValue()).constraint, (ITermVar)e.getKey());
        });
        SetMultimap edgeStuck = new SetMultimap();
        this.stuckOnEdge.entries().filter(e -> !((Delayed)e.getValue()).activated).forEach(e -> {
            boolean bl = edgeStuck.put(((Delayed)e.getValue()).constraint, (CriticalEdge)e.getKey());
        });
        HashSet stuck = new HashSet();
        stuck.addAll(varStuck.keySet());
        stuck.addAll(edgeStuck.keySet());
        Map.Transient delayed = CapsuleUtil.transientMap();
        stuck.stream().forEach(c -> {
            Object object = delayed.__put(c, (Object)new Delay((Iterable<? extends ITermVar>)varStuck.get(c), (Iterable<CriticalEdge>)edgeStuck.get(c)));
        });
        return delayed.freeze();
    }

    @Override
    public Collection<IConstraint> active() {
        return Collections.unmodifiableCollection(this.active);
    }

    private static class Delayed {
        public final IConstraint constraint;
        private boolean activated = false;

        public Delayed(IConstraint constraint) {
            this.constraint = constraint;
        }

        public boolean activate() {
            if (this.activated) {
                return false;
            }
            this.activated = true;
            return true;
        }

        public String toString() {
            return this.activated ? "*" : this.constraint.toString();
        }
    }
}

