/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.query;

import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collector;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.util.TermFormatter;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.tuple.Tuple2;

public enum QueryProject implements Serializable,
Function1<ITerm, Optional<ITerm>>
{
    FULL,
    TARGET_DATA,
    DATA;


    @Override
    public Optional<ITerm> apply(ITerm t) {
        switch (this) {
            case FULL: {
                return Optional.of(t);
            }
            case TARGET_DATA: {
                return StatixTerms.pathTargetAndData(t).map(target -> TermBuild.B.newTuple((ITerm)target._1(), (ITerm)target._2()));
            }
            case DATA: {
                return StatixTerms.pathTargetAndData(t).map(Tuple2::_2);
            }
        }
        throw new IllegalArgumentException("Unknown projection: " + this);
    }

    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("project ");
        sb.append(this.toString());
        return sb.toString();
    }

    public String toString() {
        switch (this) {
            case FULL: {
                return "*";
            }
            case TARGET_DATA: {
                return "target";
            }
            case DATA: {
                return "$";
            }
        }
        throw new IllegalArgumentException("Unknown projection: " + this);
    }

    public Collector<ITerm, ?, ? extends Collection<ITerm>> collector() {
        switch (this) {
            case FULL: {
                return ImList.Immutable.toImmutableList();
            }
        }
        return CapsuleCollectors.toSet();
    }
}

