/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.Collection;
import mb.nabl2.terms.ITermVar;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.Solver;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.unit.Unit;

public abstract class StepResult {
    public abstract <T, E extends Throwable> T match(OnSuccess<T, E> var1, Function1<Throwable, T> var2, Function1<Delay, T> var3) throws E;

    public void visit(OnSuccessAction onSuccess, Action1<Throwable> onFailure, Action1<Delay> onDelay) {
        this.match((newState, updatedVars, newConstraints, newCompleteness, newExistentials) -> {
            onSuccess.apply(newState, (Set.Immutable<ITermVar>)updatedVars, newConstraints, newCompleteness, (Map.Immutable<ITermVar, ITermVar>)newExistentials);
            return Unit.unit;
        }, ex -> {
            onFailure.apply((Throwable)ex);
            return Unit.unit;
        }, delay -> {
            onDelay.apply((Delay)delay);
            return Unit.unit;
        });
    }

    public static Success success(IState.Immutable newState) {
        return new Success(newState);
    }

    public static StepResult failure(@Nullable Throwable exception) {
        return new Failure(exception);
    }

    public static StepResult failure() {
        return new Failure(null);
    }

    public static StepResult delay(Delay delay) {
        return new Delayed(delay);
    }

    private static class Delayed
    extends StepResult {
        private final Delay delay;

        private Delayed(Delay delay) {
            this.delay = delay;
        }

        @Override
        public <T, E extends Throwable> T match(OnSuccess<T, E> onSuccess, Function1<Throwable, T> onFailure, Function1<Delay, T> onDelay) throws E {
            return onDelay.apply(this.delay);
        }
    }

    private static class Failure
    extends StepResult {
        @Nullable
        private final Throwable exception;

        private Failure(@Nullable Throwable exception) {
            this.exception = exception;
        }

        @Override
        public <T, E extends Throwable> T match(OnSuccess<T, E> onSuccess, Function1<Throwable, T> onFailure, Function1<Delay, T> onDelay) {
            return onFailure.apply(this.exception);
        }
    }

    public static interface OnSuccess<R, E extends Throwable> {
        public R apply(IState.Immutable var1, Set.Immutable<ITermVar> var2, Collection<IConstraint> var3, ICompleteness.Immutable var4, Map.Immutable<ITermVar, ITermVar> var5) throws E;
    }

    public static interface OnSuccessAction {
        public void apply(IState.Immutable var1, Set.Immutable<ITermVar> var2, Collection<IConstraint> var3, ICompleteness.Immutable var4, Map.Immutable<ITermVar, ITermVar> var5);
    }

    public static class Success
    extends StepResult {
        private final IState.Immutable newState;
        private final Set.Immutable<ITermVar> updatedVars;
        private final Collection<IConstraint> newConstraints;
        private final ICompleteness.Immutable newCriticalEdges;
        private final Map.Immutable<ITermVar, ITermVar> newExistentials;

        private Success(IState.Immutable newState, Set.Immutable<ITermVar> updatedVars, Collection<IConstraint> newConstraints, ICompleteness.Immutable newCriticalEdges, Map.Immutable<ITermVar, ITermVar> newExistentials) {
            this.newState = newState;
            this.updatedVars = updatedVars;
            this.newConstraints = newConstraints;
            this.newCriticalEdges = newCriticalEdges;
            this.newExistentials = newExistentials;
        }

        private Success(IState.Immutable newState) {
            this(newState, Solver.NO_UPDATED_VARS, Solver.NO_NEW_CONSTRAINTS, Solver.NO_NEW_CRITICAL_EDGES, Solver.NO_EXISTENTIALS);
        }

        public IState.Immutable newState() {
            return this.newState;
        }

        public Set.Immutable<ITermVar> updatedVars() {
            return this.updatedVars;
        }

        public Collection<IConstraint> newConstraints() {
            return this.newConstraints;
        }

        public ICompleteness.Immutable newCriticalEdges() {
            return this.newCriticalEdges;
        }

        public Map.Immutable<ITermVar, ITermVar> newExistentials() {
            return this.newExistentials;
        }

        public Success withNewState(IState.Immutable newState) {
            return new Success(newState);
        }

        public Success withUpdatedVars(Set.Immutable<ITermVar> updatedVars) {
            return new Success(this.newState, updatedVars, this.newConstraints, this.newCriticalEdges, this.newExistentials);
        }

        public Success withNewConstraints(Collection<IConstraint> newConstraints) {
            return new Success(this.newState, this.updatedVars, newConstraints, this.newCriticalEdges, this.newExistentials);
        }

        public Success withNewCriticalEdges(ICompleteness.Immutable newCriticalEdges) {
            return new Success(this.newState, this.updatedVars, this.newConstraints, newCriticalEdges, this.newExistentials);
        }

        public Success withNewExistentials(Map.Immutable<ITermVar, ITermVar> newExistentials) {
            return new Success(this.newState, this.updatedVars, this.newConstraints, this.newCriticalEdges, newExistentials);
        }

        @Override
        public <T, E extends Throwable> T match(OnSuccess<T, E> onSuccess, Function1<Throwable, T> onFailure, Function1<Delay, T> onDelay) throws E {
            return onSuccess.apply(this.newState, this.updatedVars, this.newConstraints, this.newCriticalEdges, this.newExistentials);
        }
    }
}

