/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.statix.constraints.CNew;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.step.ACNewStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CNewStep
extends ACNewStep {
    private final CNew constraint;
    private final StepResult result;
    @Nullable
    private final Scope newScope;
    @Nullable
    private final ITerm scopeData;
    private transient int hashCode;

    private CNewStep(CNew constraint, StepResult result, @Nullable Scope newScope, @Nullable ITerm scopeData) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.newScope = newScope;
        this.scopeData = scopeData;
    }

    private CNewStep(CNewStep original, CNew constraint, StepResult result, @Nullable Scope newScope, @Nullable ITerm scopeData) {
        this.constraint = constraint;
        this.result = result;
        this.newScope = newScope;
        this.scopeData = scopeData;
    }

    @Override
    public CNew constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public Scope newScope() {
        return this.newScope;
    }

    @Override
    @Nullable
    public ITerm scopeData() {
        return this.scopeData;
    }

    public final CNewStep withConstraint(CNew value) {
        if (this.constraint == value) {
            return this;
        }
        CNew newValue = Objects.requireNonNull(value, "constraint");
        return new CNewStep(this, newValue, this.result, this.newScope, this.scopeData);
    }

    public final CNewStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CNewStep(this, this.constraint, newValue, this.newScope, this.scopeData);
    }

    public final CNewStep withNewScope(@Nullable Scope value) {
        if (this.newScope == value) {
            return this;
        }
        return new CNewStep(this, this.constraint, this.result, value, this.scopeData);
    }

    public final CNewStep withScopeData(@Nullable ITerm value) {
        if (this.scopeData == value) {
            return this;
        }
        return new CNewStep(this, this.constraint, this.result, this.newScope, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CNewStep && this.equalTo(0, (CNewStep)another);
    }

    private boolean equalTo(int synthetic, CNewStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.newScope, another.newScope) && Objects.equals(this.scopeData, another.scopeData);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.newScope);
        h += (h << 5) + Objects.hashCode(this.scopeData);
        return h;
    }

    public String toString() {
        return "CNewStep{constraint=" + this.constraint + ", result=" + this.result + ", newScope=" + this.newScope + ", scopeData=" + this.scopeData + "}";
    }

    public static CNewStep of(CNew constraint, StepResult result, @Nullable Scope newScope, @Nullable ITerm scopeData) {
        return new CNewStep(constraint, result, newScope, scopeData);
    }

    public static CNewStep copyOf(ACNewStep instance) {
        if (instance instanceof CNewStep) {
            return (CNewStep)instance;
        }
        return CNewStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CNewStep(CNewStep cNewStep, CNew cNew, StepResult stepResult, Scope scope, ITerm iTerm, CNewStep cNewStep2) {
        this(cNewStep, cNew, stepResult, scope, iTerm);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CNew constraint;
        private StepResult result;
        private Scope newScope;
        private ITerm scopeData;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ACNewStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof ACNewStep) {
                instance = (ACNewStep)object;
                ITerm scopeDataValue = ((ACNewStep)instance).scopeData();
                if (scopeDataValue != null) {
                    this.scopeData(scopeDataValue);
                }
                this.constraint(((ACNewStep)instance).constraint());
                Scope newScopeValue = ((ACNewStep)instance).newScope();
                if (newScopeValue != null) {
                    this.newScope(newScopeValue);
                }
            }
        }

        public final Builder constraint(CNew constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder newScope(@Nullable Scope newScope) {
            this.newScope = newScope;
            return this;
        }

        public final Builder scopeData(@Nullable ITerm scopeData) {
            this.scopeData = scopeData;
            return this;
        }

        public CNewStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CNewStep(null, this.constraint, this.result, this.newScope, this.scopeData, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CNewStep, some of required attributes are not set " + attributes;
        }
    }
}

