/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CArith;
import mb.statix.solver.persistent.step.ACArithStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CArithStep
extends ACArithStep {
    private final CArith constraint;
    private final StepResult result;
    private transient int hashCode;

    private CArithStep(CArith constraint, StepResult result) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
    }

    private CArithStep(CArithStep original, CArith constraint, StepResult result) {
        this.constraint = constraint;
        this.result = result;
    }

    @Override
    public CArith constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    public final CArithStep withConstraint(CArith value) {
        if (this.constraint == value) {
            return this;
        }
        CArith newValue = Objects.requireNonNull(value, "constraint");
        return new CArithStep(this, newValue, this.result);
    }

    public final CArithStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CArithStep(this, this.constraint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CArithStep && this.equalTo(0, (CArithStep)another);
    }

    private boolean equalTo(int synthetic, CArithStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "CArithStep{constraint=" + this.constraint + ", result=" + this.result + "}";
    }

    public static CArithStep of(CArith constraint, StepResult result) {
        return new CArithStep(constraint, result);
    }

    public static CArithStep copyOf(ACArithStep instance) {
        if (instance instanceof CArithStep) {
            return (CArithStep)instance;
        }
        return CArithStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CArithStep(CArithStep cArithStep, CArith cArith, StepResult stepResult, CArithStep cArithStep2) {
        this(cArithStep, cArith, stepResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CArith constraint;
        private StepResult result;

        private Builder() {
        }

        public final Builder from(ACArithStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACArithStep) {
                instance = (ACArithStep)object;
                this.constraint(((ACArithStep)instance).constraint());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CArith constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CArithStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CArithStep(null, this.constraint, this.result, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CArithStep, some of required attributes are not set " + attributes;
        }
    }
}

