/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.oopsla20.reference.Env;
import mb.statix.constraints.IResolveQuery;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.step.AAResolveQueryStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class AResolveQueryStep
extends AAResolveQueryStep {
    private final IResolveQuery constraint;
    private final StepResult result;
    @Nullable
    private final Env<Scope, ITerm, ITerm> answer;
    private transient int hashCode;

    private AResolveQueryStep(IResolveQuery constraint, StepResult result, @Nullable Env<Scope, ITerm, ITerm> answer) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.answer = answer;
    }

    private AResolveQueryStep(AResolveQueryStep original, IResolveQuery constraint, StepResult result, @Nullable Env<Scope, ITerm, ITerm> answer) {
        this.constraint = constraint;
        this.result = result;
        this.answer = answer;
    }

    @Override
    public IResolveQuery constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public Env<Scope, ITerm, ITerm> answer() {
        return this.answer;
    }

    public final AResolveQueryStep withConstraint(IResolveQuery value) {
        if (this.constraint == value) {
            return this;
        }
        IResolveQuery newValue = Objects.requireNonNull(value, "constraint");
        return new AResolveQueryStep(this, newValue, this.result, this.answer);
    }

    public final AResolveQueryStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new AResolveQueryStep(this, this.constraint, newValue, this.answer);
    }

    public final AResolveQueryStep withAnswer(@Nullable Env<Scope, ITerm, ITerm> value) {
        if (this.answer == value) {
            return this;
        }
        return new AResolveQueryStep(this, this.constraint, this.result, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AResolveQueryStep && this.equalTo(0, (AResolveQueryStep)another);
    }

    private boolean equalTo(int synthetic, AResolveQueryStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.answer, another.answer);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.answer);
        return h;
    }

    public String toString() {
        return "AResolveQueryStep{constraint=" + this.constraint + ", result=" + this.result + ", answer=" + this.answer + "}";
    }

    public static AResolveQueryStep of(IResolveQuery constraint, StepResult result, @Nullable Env<Scope, ITerm, ITerm> answer) {
        return new AResolveQueryStep(constraint, result, answer);
    }

    public static AResolveQueryStep copyOf(AAResolveQueryStep instance) {
        if (instance instanceof AResolveQueryStep) {
            return (AResolveQueryStep)instance;
        }
        return AResolveQueryStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ AResolveQueryStep(AResolveQueryStep aResolveQueryStep, IResolveQuery iResolveQuery, StepResult stepResult, Env env, AResolveQueryStep aResolveQueryStep2) {
        this(aResolveQueryStep, iResolveQuery, stepResult, env);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private IResolveQuery constraint;
        private StepResult result;
        private Env<Scope, ITerm, ITerm> answer;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AAResolveQueryStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof AAResolveQueryStep) {
                instance = (AAResolveQueryStep)object;
                Env<Scope, ITerm, ITerm> answerValue = ((AAResolveQueryStep)instance).answer();
                if (answerValue != null) {
                    this.answer(answerValue);
                }
                this.constraint(((AAResolveQueryStep)instance).constraint());
            }
        }

        public final Builder constraint(IResolveQuery constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder answer(@Nullable Env<Scope, ITerm, ITerm> answer) {
            this.answer = answer;
            return this;
        }

        public AResolveQueryStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AResolveQueryStep(null, this.constraint, this.result, this.answer, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build AResolveQueryStep, some of required attributes are not set " + attributes;
        }
    }
}

