/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CTellEdge
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm sourceTerm;
    private final ITerm label;
    private final ITerm targetTerm;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final CTellEdge origin;
    @Nullable
    private final ICompleteness.Immutable ownCriticalEdges;
    private final int hashCode = this.computeHashCode();

    public CTellEdge(ITerm sourceTerm, ITerm label, ITerm targetTerm) {
        this(sourceTerm, label, targetTerm, null, null, null);
    }

    private CTellEdge(ITerm sourceTerm, ITerm label, ITerm targetTerm, @Nullable IConstraint cause, @Nullable CTellEdge origin, @Nullable ICompleteness.Immutable ownCriticalEdges) {
        this.sourceTerm = sourceTerm;
        this.label = label;
        this.targetTerm = targetTerm;
        this.cause = cause;
        this.origin = origin;
        this.ownCriticalEdges = ownCriticalEdges;
    }

    public ITerm sourceTerm() {
        return this.sourceTerm;
    }

    public ITerm label() {
        return this.label;
    }

    public ITerm targetTerm() {
        return this.targetTerm;
    }

    public CTellEdge withArguments(ITerm sourceTerm, ITerm label, ITerm targetTerm) {
        if (this.sourceTerm == sourceTerm && this.label == label && this.targetTerm == targetTerm) {
            return this;
        }
        return new CTellEdge(sourceTerm, label, targetTerm, this.cause, this.origin, this.ownCriticalEdges);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CTellEdge withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CTellEdge(this.sourceTerm, this.label, this.targetTerm, cause, this.origin, this.ownCriticalEdges);
    }

    @Override
    @Nullable
    public CTellEdge origin() {
        return this.origin;
    }

    @Override
    public Optional<ICompleteness.Immutable> ownCriticalEdges() {
        return Optional.ofNullable(this.ownCriticalEdges);
    }

    @Override
    public CTellEdge withOwnCriticalEdges(ICompleteness.Immutable criticalEdges) {
        if (this.ownCriticalEdges == criticalEdges) {
            return this;
        }
        return new CTellEdge(this.sourceTerm, this.label, this.targetTerm, this.cause, this.origin, criticalEdges);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTellEdge(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTellEdge(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.sourceTerm.getVars(), this.targetTerm.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.sourceTerm.getVars().forEach(onFreeVar::apply);
        this.targetTerm.getVars().forEach(onFreeVar::apply);
    }

    @Override
    public CTellEdge apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CTellEdge unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CTellEdge apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CTellEdge apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CTellEdge(subst.apply(this.sourceTerm), this.label, subst.apply(this.targetTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CTellEdge unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CTellEdge apply(IRenaming subst, boolean trackOrigin) {
        return new CTellEdge(subst.apply(this.sourceTerm), this.label, subst.apply(this.targetTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(termToString.format(this.sourceTerm));
        sb.append(" -");
        sb.append(termToString.format(this.label));
        sb.append("-> ");
        sb.append(termToString.format(this.targetTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTellEdge that = (CTellEdge)o;
        return this.hashCode == that.hashCode && Objects.equals(this.sourceTerm, that.sourceTerm) && Objects.equals(this.label, that.label) && Objects.equals(this.targetTerm, that.targetTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.sourceTerm, this.label, this.targetTerm, this.cause, this.origin);
    }
}

