/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mb.scopegraph.regexp.Deriver;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpMatcher;
import mb.scopegraph.regexp.IState;
import mb.scopegraph.regexp.impl.RegExpNormalizingBuilder;
import mb.scopegraph.regexp.impl.RegExps;
import org.metaborg.util.collection.Sets;

public class RegExpMatcher<S>
implements IRegExpMatcher<S>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final State<S> state;

    private RegExpMatcher(State<S> state) {
        this.state = state;
    }

    @Override
    public IRegExp<S> regexp() {
        return ((State)this.state).regexp;
    }

    @Override
    public IState<S> state() {
        return this.state;
    }

    @Override
    public RegExpMatcher<S> match(S symbol) {
        return new RegExpMatcher<S>(this.state.transition((Object)symbol));
    }

    @Override
    public IRegExpMatcher<S> match(Iterable<S> symbols) {
        IRegExpMatcher<S> matcher = this;
        for (S symbol : symbols) {
            matcher = matcher.match((Object)symbol);
        }
        return matcher;
    }

    @Override
    public boolean isAccepting() {
        return this.state.isAccepting();
    }

    @Override
    public boolean isFinal() {
        return !((State)this.state).nonFinal;
    }

    public String toString() {
        return ((State)this.state).regexp.toString();
    }

    public static <S> IRegExpMatcher<S> create(IRegExp<S> initial) {
        State _state;
        IAlphabet alphabet = RegExps.alphabet(initial);
        RegExpNormalizingBuilder builder = new RegExpNormalizingBuilder(alphabet);
        Object empty = builder.emptySet();
        ArrayList derivers = new ArrayList();
        for (Object symbol : alphabet) {
            derivers.add(new Deriver(symbol, builder));
        }
        Deriver<Object> defaultDeriver = new Deriver<Object>(null, builder);
        HashMap<IRegExp, Object> stateTransitions = new HashMap<IRegExp, Object>();
        HashMap<IRegExp, IRegExp> defaultTransitions = new HashMap<IRegExp, IRegExp>();
        HashMap<Object, HashSet<IRegExp>> reverseTransitions = new HashMap<Object, HashSet<IRegExp>>();
        ArrayDeque<Object> worklist = new ArrayDeque<Object>();
        worklist.push(initial);
        worklist.push(empty);
        while (!worklist.isEmpty()) {
            IRegExp state = (IRegExp)worklist.pop();
            HashMap transitions = new HashMap(Sets.hashCapacity(derivers.size()));
            if (stateTransitions.containsKey(state)) continue;
            for (Deriver deriver : derivers) {
                IRegExp nextState = (IRegExp)builder.apply((IRegExp)deriver.apply(state));
                HashSet<IRegExp> reverseStates = (HashSet<IRegExp>)reverseTransitions.get(nextState);
                if (reverseStates == null) {
                    reverseStates = new HashSet<IRegExp>();
                    reverseTransitions.put(nextState, reverseStates);
                }
                reverseStates.add(state);
                transitions.put(deriver.getSymbol(), nextState);
                worklist.push(nextState);
            }
            IRegExp iRegExp = (IRegExp)builder.apply((IRegExp)defaultDeriver.apply(state));
            HashSet<IRegExp> reverseStates = (HashSet<IRegExp>)reverseTransitions.get(iRegExp);
            if (reverseStates == null) {
                reverseStates = new HashSet<IRegExp>();
                reverseTransitions.put(iRegExp, reverseStates);
            }
            reverseStates.add(state);
            defaultTransitions.put(state, iRegExp);
            worklist.push(iRegExp);
            stateTransitions.put(state, transitions);
        }
        for (IRegExp state : stateTransitions.keySet()) {
            if (!RegExps.isNullable(state)) continue;
            worklist.push(state);
        }
        HashSet<IRegExp> visited = new HashSet<IRegExp>();
        HashSet<IRegExp> nonFinal = new HashSet<IRegExp>();
        while (!worklist.isEmpty()) {
            IRegExp iRegExp = (IRegExp)worklist.pop();
            if (visited.contains(iRegExp)) continue;
            visited.add(iRegExp);
            if (!reverseTransitions.containsKey(iRegExp)) continue;
            for (IRegExp nextState : (Set)reverseTransitions.get(iRegExp)) {
                nonFinal.add(nextState);
                worklist.push(nextState);
            }
        }
        Set set = stateTransitions.keySet().stream().filter(RegExps::isNullable).collect(Collectors.toSet());
        HashMap<IRegExp, State> states = new HashMap<IRegExp, State>(Sets.hashCapacity(stateTransitions.size()));
        for (IRegExp state : stateTransitions.keySet()) {
            _state = new State(state);
            states.put(state, _state);
            _state.isNullable = set.contains(state);
            _state.nonFinal = nonFinal.contains(state);
        }
        for (IRegExp state : stateTransitions.keySet()) {
            _state = (State)states.get(state);
            _state.defaultTransition = (State)states.get(defaultTransitions.get(state));
            _state.symbolTransitions = ((Map)stateTransitions.get(state)).entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> (State)states.get(e.getValue())));
        }
        return new RegExpMatcher<S>((State)states.get(initial));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExpMatcher that = (RegExpMatcher)o;
        return Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    private static class State<S>
    implements Serializable,
    IState<S> {
        private static final long serialVersionUID = 1L;
        private final IRegExp<S> regexp;
        private Map<S, State<S>> symbolTransitions;
        private State<S> defaultTransition;
        private boolean nonFinal;
        private boolean isNullable;

        private State(IRegExp<S> regexp) {
            this.regexp = regexp;
        }

        @Override
        public boolean isFinal() {
            return !this.nonFinal;
        }

        @Override
        public boolean isAccepting() {
            return this.isNullable;
        }

        @Override
        public boolean isOblivion() {
            return RegExps.isOblivion(this.regexp);
        }

        @Override
        public State<S> transition(S symbol) {
            return this.symbolTransitions.getOrDefault(symbol, this.defaultTransition);
        }

        public int hashCode() {
            return Objects.hash(this.regexp);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            return Objects.equals(this.regexp, other.regexp);
        }

        public String toString() {
            return this.regexp.toString();
        }
    }
}

