/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms.path;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.path.IScopePath;
import mb.scopegraph.pepm16.path.IStep;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.ConsList;
import org.metaborg.util.iterators.Iterables2;

@Value.Immutable
@Serial.Version(value=42L)
abstract class AComposedScopePath<S extends IScope, L extends ILabel, O extends IOccurrence>
implements IScopePath<S, L, O> {
    AComposedScopePath() {
    }

    @Value.Parameter
    public abstract IScopePath<S, L, O> getLeft();

    @Value.Parameter
    public abstract IScopePath<S, L, O> getRight();

    @Nullable
    @Value.Check
    public AComposedScopePath<S, L, O> check() {
        if (!this.getLeft().getTarget().equals(this.getRight().getSource())) {
            return null;
        }
        if (this.getScopes().size() <= this.size()) {
            return null;
        }
        return this;
    }

    @Override
    @Value.Lazy
    public S getSource() {
        return this.getLeft().getSource();
    }

    @Override
    @Value.Lazy
    public S getTarget() {
        return this.getRight().getTarget();
    }

    @Override
    @Value.Lazy
    public int size() {
        return this.getLeft().size() + this.getRight().size();
    }

    @Override
    @Value.Lazy
    public Set.Immutable<O> getImports() {
        return this.getLeft().getImports().__insertAll(this.getRight().getImports());
    }

    @Override
    public Iterable<IResolutionPath<S, L, O>> getImportPaths() {
        return Iterables2.fromConcat(this.getLeft().getImportPaths(), this.getRight().getImportPaths());
    }

    @Override
    @Value.Lazy
    public Set.Immutable<S> getScopes() {
        return this.getLeft().getScopes().__insertAll(this.getRight().getScopes());
    }

    @Override
    @Value.Lazy
    public ConsList<L> getLabels() {
        return this.getLeft().getLabels().append(this.getRight().getLabels());
    }

    @Override
    @Value.Lazy
    public int hashCode() {
        return this.getLeft().hashCode() + BigInteger.valueOf(31L).pow(this.getLeft().size()).intValue() * this.getRight().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IScopePath)) {
            return false;
        }
        IScopePath other = (IScopePath)obj;
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        if (!this.getTarget().equals(other.getTarget())) {
            return false;
        }
        Iterator iterator1 = this.iterator();
        Iterator iterator2 = other.iterator();
        while (iterator1.hasNext()) {
            IStep o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            IStep o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    @Override
    public String toString(boolean includeSource, boolean includeTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLeft().toString(includeSource, true));
        sb.append(" ");
        sb.append(this.getRight().toString(false, includeTarget));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }
}

