/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.util.ArrayList;
import java.util.List;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.INameResolution;
import mb.scopegraph.pepm16.IScopeGraph;
import mb.scopegraph.pepm16.StuckException;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import mb.scopegraph.pepm16.terms.path.Paths;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public final class NameResolutionTerms {
    private final IScopeGraph<Scope, Label, Occurrence> scopeGraph;
    private final INameResolution<Scope, Label, Occurrence> nameResolution;
    private final ICancel cancel;
    private final IProgress progress;

    private NameResolutionTerms(IScopeGraph<Scope, Label, Occurrence> scopeGraph, INameResolution<Scope, Label, Occurrence> nameResolution, ICancel cancel, IProgress progress) {
        this.scopeGraph = scopeGraph;
        this.nameResolution = nameResolution;
        this.cancel = cancel;
        this.progress = progress;
    }

    private ITerm build() throws InterruptedException {
        ArrayList<ITerm> resolutions = new ArrayList<ITerm>();
        for (Occurrence ref : this.scopeGraph.getAllRefs()) {
            resolutions.add(this.buildRef(ref));
        }
        return TermBuild.B.newAppl("NameResolution", TermBuild.B.newList(resolutions));
    }

    private ITerm buildRef(Occurrence ref) throws InterruptedException {
        List<ITerm> paths;
        try {
            paths = this.nameResolution.resolve(ref, this.cancel, this.progress).stream().map(this::buildPath).collect(ImList.Immutable.toImmutableList());
        }
        catch (CriticalEdgeException | StuckException e) {
            paths = ImList.Immutable.of(new ITerm[0]);
        }
        IApplTerm result = paths.isEmpty() ? TermBuild.B.newAppl("NoResolution", new ITerm[0]) : TermBuild.B.newAppl("Resolution", TermBuild.B.newList(paths));
        return TermBuild.B.newTuple(ref, result);
    }

    private ITerm buildPath(IResolutionPath<Scope, Label, Occurrence> path) {
        return TermBuild.B.newTuple((ITerm)path.getDeclaration(), Paths.toTerm(path));
    }

    public static ITerm build(IScopeGraph<Scope, Label, Occurrence> scopeGraph, INameResolution<Scope, Label, Occurrence> nameResolution, ICancel cancel, IProgress progress) throws InterruptedException {
        return new NameResolutionTerms(scopeGraph, nameResolution, cancel, progress).build();
    }
}

