/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16;

import java.util.List;
import mb.nabl2.solver.TypeException;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.Ref;

public class ScopeGraphReducer {
    private final IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph;
    private final Ref<IUnifier.Immutable> unifier;

    public ScopeGraphReducer(IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph, Ref<IUnifier.Immutable> unifier) {
        this.scopeGraph = scopeGraph;
        this.unifier = unifier;
    }

    public List<CriticalEdge> updateAll() throws InterruptedException {
        List<CriticalEdge> criticalEdges = this.scopeGraph.reduceAll(this.unifier.get()::getVars, this::findScope, this::findOccurrence);
        return criticalEdges;
    }

    public List<CriticalEdge> update(Iterable<? extends ITerm> vars) throws InterruptedException {
        List<CriticalEdge> criticalEdges = this.scopeGraph.reduce(vars, this.unifier.get()::getVars, this::findScope, this::findOccurrence);
        return criticalEdges;
    }

    private Scope findScope(ITerm scopeTerm) {
        return Scope.matcher().match(scopeTerm, this.unifier.get()).orElseThrow(() -> new TypeException("Expected a scope, got " + this.unifier.get().toString(scopeTerm)));
    }

    private Occurrence findOccurrence(ITerm occurrenceTerm) {
        return Occurrence.matcher().match(occurrenceTerm, this.unifier.get()).orElseThrow(() -> new TypeException("Expected an occurrence, got " + this.unifier.get().toString(occurrenceTerm)));
    }
}

