/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import java.io.Serializable;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

public abstract class EdgeOrData<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final EdgeOrData DATA = new Data();

    public abstract <R> R matchInResolution(OnData<R> var1, OnEdge<L, R> var2) throws ResolutionException, InterruptedException;

    public abstract <R> R match(Function0<R> var1, Function1<L, R> var2);

    public static <L> EdgeOrData<L> data() {
        return DATA;
    }

    public static <L> EdgeOrData<L> edge(L l) {
        return new Edge(l);
    }

    private static class Data<L>
    extends EdgeOrData<L> {
        private static final long serialVersionUID = 1L;

        private Data() {
        }

        @Override
        public <R> R matchInResolution(OnData<R> onData, OnEdge<L, R> onEdge) throws ResolutionException, InterruptedException {
            return onData.apply();
        }

        @Override
        public <R> R match(Function0<R> onData, Function1<L, R> onEdge) {
            return onData.apply();
        }

        public int hashCode() {
            return 7;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.getClass() == obj.getClass();
        }

        public String toString() {
            return "<data>";
        }
    }

    private static class Edge<L>
    extends EdgeOrData<L> {
        private static final long serialVersionUID = 1L;
        private final L label;
        private volatile int hashCode;

        private Edge(L label) {
            this.label = label;
        }

        @Override
        public <R> R matchInResolution(OnData<R> onData, OnEdge<L, R> onEdge) throws ResolutionException, InterruptedException {
            return onEdge.apply(this.label);
        }

        @Override
        public <R> R match(Function0<R> onData, Function1<L, R> onEdge) {
            return onEdge.apply(this.label);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = this.label.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            return this.label.equals(other.label);
        }

        public String toString() {
            return "<edge>" + this.label;
        }
    }

    @FunctionalInterface
    public static interface OnData<R> {
        public R apply() throws ResolutionException, InterruptedException;
    }

    @FunctionalInterface
    public static interface OnEdge<L, R> {
        public R apply(L var1) throws ResolutionException, InterruptedException;
    }
}

