/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import mb.resource.hierarchical.match.path.string.AllPathStringMatcher;
import mb.resource.hierarchical.match.path.string.AntPatternPathStringMatcher;
import mb.resource.hierarchical.match.path.string.AntPatternsPathStringMatcher;
import mb.resource.hierarchical.match.path.string.AnyPathStringMatcher;
import mb.resource.hierarchical.match.path.string.ExtensionPathStringMatcher;
import mb.resource.hierarchical.match.path.string.ExtensionsPathStringMatcher;
import mb.resource.hierarchical.match.path.string.FalsePathStringMatcher;
import mb.resource.hierarchical.match.path.string.NotPathStringMatcher;
import mb.resource.hierarchical.match.path.string.RegexPathStringMatcher;
import mb.resource.hierarchical.match.path.string.TruePathStringMatcher;
import mb.resource.util.AntPattern;

@FunctionalInterface
public interface PathStringMatcher
extends Serializable {
    public boolean matches(String var1);

    public static TruePathStringMatcher ofTrue() {
        return new TruePathStringMatcher();
    }

    public static FalsePathStringMatcher ofFalse() {
        return new FalsePathStringMatcher();
    }

    public static AllPathStringMatcher ofAll(PathStringMatcher ... matchers) {
        return new AllPathStringMatcher(matchers);
    }

    public static AnyPathStringMatcher ofAny(PathStringMatcher ... matchers) {
        return new AnyPathStringMatcher(matchers);
    }

    public static NotPathStringMatcher ofNot(PathStringMatcher matcher) {
        return new NotPathStringMatcher(matcher);
    }

    public static ExtensionPathStringMatcher ofExtension(String extension) {
        return new ExtensionPathStringMatcher(extension);
    }

    public static ExtensionsPathStringMatcher ofExtensions(String ... extensions) {
        return new ExtensionsPathStringMatcher(extensions);
    }

    public static AntPatternPathStringMatcher ofAntPattern(AntPattern antPattern) {
        return new AntPatternPathStringMatcher(antPattern);
    }

    public static AntPatternPathStringMatcher ofAntPattern(String antPattern) {
        return new AntPatternPathStringMatcher(antPattern);
    }

    public static AntPatternsPathStringMatcher ofAntPatterns(AntPattern ... antPatterns) {
        return new AntPatternsPathStringMatcher(antPatterns);
    }

    public static AntPatternsPathStringMatcher ofAntPatterns(String ... antPatterns) {
        return new AntPatternsPathStringMatcher(antPatterns);
    }

    public static RegexPathStringMatcher ofRegex(String regex) {
        return new RegexPathStringMatcher(regex);
    }

    default public NotPathStringMatcher not() {
        return new NotPathStringMatcher(this);
    }

    default public AllPathStringMatcher and(PathStringMatcher ... matchers) {
        ArrayList<PathStringMatcher> allMatchers = new ArrayList<PathStringMatcher>(matchers.length + 1);
        allMatchers.add(this);
        Collections.addAll(allMatchers, matchers);
        return new AllPathStringMatcher(allMatchers);
    }

    default public AnyPathStringMatcher or(PathStringMatcher ... matchers) {
        ArrayList<PathStringMatcher> anyMatchers = new ArrayList<PathStringMatcher>(matchers.length + 1);
        anyMatchers.add(this);
        Collections.addAll(anyMatchers, matchers);
        return new AnyPathStringMatcher(anyMatchers);
    }
}

