/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EndsWithPathMatcher
implements PathMatcher {
    private final String suffix;

    public EndsWithPathMatcher(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = SeparatorUtil.convertCurrentToUnixSeparator(rootDir.relativize(path));
        return relative.endsWith(this.suffix);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndsWithPathMatcher that = (EndsWithPathMatcher)o;
        return this.suffix.equals(that.suffix);
    }

    public int hashCode() {
        return this.suffix.hashCode();
    }

    public String toString() {
        return "ends-with(" + this.suffix + ")";
    }
}

