/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.util.Collection;
import java.util.Objects;
import mb.resource.ResourceRuntimeException;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.ResourcePathDefaults;
import mb.resource.hierarchical.SegmentsIdentifier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SegmentsPath
extends ResourcePathDefaults<SegmentsPath>
implements ResourcePath {
    private final String qualifier;
    private final SegmentsIdentifier id;

    public SegmentsPath(String qualifier, SegmentsIdentifier id) {
        this.qualifier = qualifier;
        this.id = id;
    }

    public SegmentsPath(String qualifier, String id) {
        this.qualifier = qualifier;
        this.id = SegmentsIdentifier.fromString(id);
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public SegmentsIdentifier getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return this.getId().toString();
    }

    @Override
    public boolean isAbsolute() {
        return this.id.isAbsolute();
    }

    @Override
    public int getSegmentCount() {
        return this.id.getSegmentCount();
    }

    @Override
    public Iterable<String> getSegments() {
        return this.id.getSegments();
    }

    @Override
    public boolean startsWith(ResourcePath prefix) {
        if (!(prefix instanceof SegmentsPath)) {
            throw new ResourceRuntimeException("Cannot check if this path starts with '" + prefix + "', it is not a SegmentsPath");
        }
        return this.startsWith((SegmentsPath)prefix);
    }

    public boolean startsWith(SegmentsPath prefix) {
        return this.id.startsWith(prefix.id);
    }

    @Override
    public @Nullable SegmentsPath getParent() {
        @Nullable SegmentsIdentifier parent = this.id.getParent();
        if (parent == null) {
            return null;
        }
        return new SegmentsPath(this.qualifier, parent);
    }

    @Override
    public @Nullable SegmentsPath getRoot() {
        @Nullable SegmentsIdentifier root = this.id.getRoot();
        if (root == null) {
            return null;
        }
        return new SegmentsPath(this.qualifier, root);
    }

    @Override
    public @Nullable String getLeaf() {
        return this.id.getLeaf();
    }

    @Override
    public SegmentsPath getNormalized() {
        return new SegmentsPath(this.qualifier, this.id.getNormalized());
    }

    @Override
    public String relativize(ResourcePath other) {
        if (!(other instanceof SegmentsPath)) {
            throw new ResourceRuntimeException("Cannot relativize with path '" + other + "', it is not a SegmentsPath");
        }
        return this.relativize((SegmentsPath)other);
    }

    public String relativize(SegmentsPath other) {
        return this.id.relativize(other.id).toString();
    }

    @Override
    public SegmentsPath appendSegment(String segment) {
        return new SegmentsPath(this.qualifier, this.id.appendSegment(segment));
    }

    @Override
    public SegmentsPath appendSegments(Iterable<String> segments) {
        return new SegmentsPath(this.qualifier, this.id.appendSegments(segments));
    }

    @Override
    public SegmentsPath appendSegments(Collection<String> segments) {
        return new SegmentsPath(this.qualifier, this.id.appendSegments(segments));
    }

    @Override
    public SegmentsPath appendRelativePath(String relativePath) {
        return new SegmentsPath(this.qualifier, this.id.appendRelativePath(relativePath));
    }

    @Override
    public SegmentsPath appendOrReplaceWithPath(String other) {
        return new SegmentsPath(this.qualifier, this.id.appendOrReplaceWithPath(other));
    }

    @Override
    public SegmentsPath appendRelativePath(ResourcePath relativePath) {
        if (!(relativePath instanceof SegmentsPath)) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is not a SegmentsPath");
        }
        return this.appendRelativePath((SegmentsPath)relativePath);
    }

    public SegmentsPath appendRelativePath(SegmentsPath relativePath) {
        return new SegmentsPath(this.qualifier, this.id.appendRelativePath(relativePath.id));
    }

    @Override
    public SegmentsPath replaceLeaf(String segment) {
        return new SegmentsPath(this.qualifier, this.id.replaceLeaf(segment));
    }

    @Override
    protected SegmentsPath self() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsPath that = (SegmentsPath)o;
        return this.qualifier.equals(that.qualifier) && this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.qualifier, this.id);
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

