/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import mb.resource.ReadableResource;

public interface WritableResource
extends ReadableResource {
    public boolean isWritable() throws IOException;

    public void setLastModifiedTime(Instant var1) throws IOException;

    public OutputStream openWrite() throws IOException;

    default public BufferedOutputStream openWriteBuffered() throws IOException {
        return new BufferedOutputStream(this.openWrite());
    }

    public OutputStream openWriteAppend() throws IOException;

    default public BufferedOutputStream openWriteAppendBuffered() throws IOException {
        return new BufferedOutputStream(this.openWriteAppend());
    }

    public OutputStream openWriteExisting() throws IOException;

    default public BufferedOutputStream openWriteExistingBuffered() throws IOException {
        return new BufferedOutputStream(this.openWriteExisting());
    }

    public OutputStream openWriteNew() throws IOException;

    default public BufferedOutputStream openWriteNewBuffered() throws IOException {
        return new BufferedOutputStream(this.openWriteNew());
    }

    default public void writeBytes(byte[] bytes) throws IOException {
        try (BufferedOutputStream outputStream = this.openWriteBuffered();){
            ((OutputStream)outputStream).write(bytes);
            ((OutputStream)outputStream).flush();
        }
    }

    default public void writeString(String string, Charset toCharset) throws IOException {
        try (BufferedOutputStream outputStream = this.openWriteBuffered();){
            ((OutputStream)outputStream).write(string.getBytes(toCharset));
            ((OutputStream)outputStream).flush();
        }
    }

    default public void writeString(String string) throws IOException {
        this.writeString(string, StandardCharsets.UTF_8);
    }
}

