/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.StoreReadTxn;
import mb.pie.api.StringUtil;
import mb.pie.api.Task;
import mb.pie.api.TaskDef;
import mb.pie.api.TaskDefs;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaskKey
implements Serializable {
    public final String id;
    public final Serializable key;
    private transient int hashCode;
    private transient boolean hashCodeCached;

    public TaskKey(String id, Serializable key) {
        this.id = id;
        this.key = key;
    }

    public Task<?> toTask(TaskDefs taskDefs, StoreReadTxn txn) {
        @Nullable TaskDef<?, ?> taskDef = taskDefs.getTaskDef(this.id);
        if (taskDef == null) {
            throw new IllegalStateException("BUG: cannot get task definition for task key " + this.toShortString(Integer.MAX_VALUE) + "; task definition with id " + this.id + " does not exist");
        }
        @Nullable Serializable input = txn.getInput(this);
        if (input == null) {
            throw new IllegalStateException("BUG: cannot get task for task key " + this.toShortString(Integer.MAX_VALUE) + " ; input object does not exist");
        }
        return new Task(taskDef, input);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskKey taskKey = (TaskKey)o;
        if (!this.id.equals(taskKey.id)) {
            return false;
        }
        return this.key.equals(taskKey.key);
    }

    public int hashCode() {
        if (this.hashCodeCached) {
            return this.hashCode;
        }
        int result = this.id.hashCode();
        this.hashCode = result = 31 * result + this.key.hashCode();
        this.hashCodeCached = true;
        return result;
    }

    public String toShortString(int maxLength) {
        return "#" + this.id + "(" + StringUtil.toShortString(this.key.toString(), maxLength) + ")";
    }

    public String toString() {
        return this.toShortString(100);
    }
}

