/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import mb.pie.api.InconsistentResourceRequire;
import mb.pie.api.ResourceDep;
import mb.pie.api.stamp.ResourceStamp;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourceRequireDep
implements ResourceDep,
Serializable {
    public final ResourceKey key;
    public final ResourceStamp<Resource> stamp;

    public ResourceRequireDep(ResourceKey key, ResourceStamp<Resource> stamp) {
        this.key = key;
        this.stamp = stamp;
    }

    @Override
    public @Nullable InconsistentResourceRequire checkConsistency(ResourceService resourceService) {
        ResourceStamp<Resource> newStamp;
        Resource resource = resourceService.getResource(this.key);
        try {
            newStamp = this.stamp.getStamper().stamp(resource);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!this.stamp.equals(newStamp)) {
            return new InconsistentResourceRequire(this, newStamp);
        }
        return null;
    }

    @Override
    public boolean isConsistent(ResourceService resourceService) {
        ResourceStamp<Resource> newStamp;
        Resource resource = resourceService.getResource(this.key);
        try {
            newStamp = this.stamp.getStamper().stamp(resource);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.stamp.equals(newStamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRequireDep that = (ResourceRequireDep)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.stamp.equals(that.stamp);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.stamp.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceRequireDep(" + this.key + ", " + this.stamp + ")";
    }
}

