/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.ADifferState;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.tuple.Tuple2;

public final class DifferState<S, L, D>
extends ADifferState<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final Set<S> matches;
    private final Set<Tuple2<S, L>> diffs;
    private final ICompletableFuture<?> future;

    private DifferState(IActorRef<? extends IUnit<S, L, D, ?>> origin, Iterable<? extends S> matches, Iterable<? extends Tuple2<S, L>> diffs, ICompletableFuture<?> future) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.matches = DifferState.createUnmodifiableSet(DifferState.createSafeList(matches, true, false));
        this.diffs = DifferState.createUnmodifiableSet(DifferState.createSafeList(diffs, true, false));
        this.future = Objects.requireNonNull(future, "future");
    }

    private DifferState(DifferState<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, Set<S> matches, Set<Tuple2<S, L>> diffs, ICompletableFuture<?> future) {
        this.origin = origin;
        this.matches = matches;
        this.diffs = diffs;
        this.future = future;
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public Set<S> matches() {
        return this.matches;
    }

    @Override
    public Set<Tuple2<S, L>> diffs() {
        return this.diffs;
    }

    @Override
    public ICompletableFuture<?> future() {
        return this.future;
    }

    public final DifferState<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new DifferState<S, L, D>(this, newValue, this.matches, this.diffs, this.future);
    }

    @SafeVarargs
    public final DifferState<S, L, D> withMatches(S ... elements) {
        Set<S> newValue = DifferState.createUnmodifiableSet(DifferState.createSafeList(Arrays.asList(elements), true, false));
        return new DifferState<S, L, D>(this, this.origin, newValue, this.diffs, this.future);
    }

    public final DifferState<S, L, D> withMatches(Iterable<? extends S> elements) {
        if (this.matches == elements) {
            return this;
        }
        Set<? extends S> newValue = DifferState.createUnmodifiableSet(DifferState.createSafeList(elements, true, false));
        return new DifferState<S, L, D>(this, this.origin, newValue, this.diffs, this.future);
    }

    @SafeVarargs
    public final DifferState<S, L, D> withDiffs(Tuple2<S, L> ... elements) {
        Set<Tuple2<S, L>> newValue = DifferState.createUnmodifiableSet(DifferState.createSafeList(Arrays.asList(elements), true, false));
        return new DifferState<S, L, D>(this, this.origin, this.matches, newValue, this.future);
    }

    public final DifferState<S, L, D> withDiffs(Iterable<? extends Tuple2<S, L>> elements) {
        if (this.diffs == elements) {
            return this;
        }
        Set<Tuple2<S, L>> newValue = DifferState.createUnmodifiableSet(DifferState.createSafeList(elements, true, false));
        return new DifferState<S, L, D>(this, this.origin, this.matches, newValue, this.future);
    }

    public final DifferState<S, L, D> withFuture(ICompletableFuture<?> value) {
        if (this.future == value) {
            return this;
        }
        ICompletableFuture<?> newValue = Objects.requireNonNull(value, "future");
        return new DifferState<S, L, D>(this, this.origin, this.matches, this.diffs, newValue);
    }

    public String toString() {
        return "DifferState{origin=" + this.origin + ", matches=" + this.matches + ", diffs=" + this.diffs + ", future=" + this.future + "}";
    }

    public static <S, L, D> DifferState<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, Set<S> matches, Set<Tuple2<S, L>> diffs, ICompletableFuture<?> future) {
        return DifferState.of(origin, matches, diffs, future);
    }

    public static <S, L, D> DifferState<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, Iterable<? extends S> matches, Iterable<? extends Tuple2<S, L>> diffs, ICompletableFuture<?> future) {
        return new DifferState<S, L, D>(origin, matches, diffs, future);
    }

    public static <S, L, D> DifferState<S, L, D> copyOf(ADifferState<S, L, D> instance) {
        if (instance instanceof DifferState) {
            return (DifferState)instance;
        }
        return DifferState.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    /* synthetic */ DifferState(DifferState differState, IActorRef iActorRef, Set set, Set set2, ICompletableFuture iCompletableFuture, DifferState differState2) {
        this(differState, iActorRef, set, set2, iCompletableFuture);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_FUTURE = 2L;
        private long initBits = 3L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private List<S> matches = new ArrayList<S>();
        private List<Tuple2<S, L>> diffs = new ArrayList<Tuple2<S, L>>();
        private ICompletableFuture<?> future;

        private Builder() {
        }

        public final Builder<S, L, D> from(ADifferState<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.addAllMatches(instance.matches());
            this.addAllDiffs(instance.diffs());
            this.future(instance.future());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> addMatches(S element) {
            this.matches.add(Objects.requireNonNull(element, "matches element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addMatches(S ... elements) {
            S[] SArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                S element = SArray[n2];
                this.matches.add(Objects.requireNonNull(element, "matches element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D> matches(Iterable<? extends S> elements) {
            this.matches.clear();
            return this.addAllMatches(elements);
        }

        public final Builder<S, L, D> addAllMatches(Iterable<? extends S> elements) {
            for (S element : elements) {
                this.matches.add(Objects.requireNonNull(element, "matches element"));
            }
            return this;
        }

        public final Builder<S, L, D> addDiffs(Tuple2<S, L> element) {
            this.diffs.add(Objects.requireNonNull(element, "diffs element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addDiffs(Tuple2<S, L> ... elements) {
            Tuple2<S, L>[] tuple2Array = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Tuple2<S, L> element = tuple2Array[n2];
                this.diffs.add(Objects.requireNonNull(element, "diffs element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D> diffs(Iterable<? extends Tuple2<S, L>> elements) {
            this.diffs.clear();
            return this.addAllDiffs(elements);
        }

        public final Builder<S, L, D> addAllDiffs(Iterable<? extends Tuple2<S, L>> elements) {
            for (Tuple2<S, L> element : elements) {
                this.diffs.add(Objects.requireNonNull(element, "diffs element"));
            }
            return this;
        }

        public final Builder<S, L, D> future(ICompletableFuture<?> future) {
            this.future = Objects.requireNonNull(future, "future");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public DifferState<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DifferState(null, this.origin, DifferState.createUnmodifiableSet(this.matches), DifferState.createUnmodifiableSet(this.diffs), this.future, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("future");
            }
            return "Cannot build DifferState, some of required attributes are not set " + attributes;
        }
    }
}

