/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import io.usethesource.capsule.Set;
import java.util.Optional;
import mb.nabl2.config.NaBL2DebugConfig;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.solvers.BaseSolution;
import mb.nabl2.solver.solvers.GraphSolution;
import mb.nabl2.solver.solvers.SingleFileSolver;
import mb.nabl2.spoofax.analysis.SingleUnitResult;
import mb.nabl2.spoofax.primitives.ScopeGraphMultiFileAnalysisPrimitive;
import mb.nabl2.stratego.ConstraintTerms;
import mb.nabl2.stratego.MessageTerms;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.nabl2.terms.unification.Unifiers;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class SG_solve_single_constraint
extends AbstractPrimitive {
    public SG_solve_single_constraint() {
        super(SG_solve_single_constraint.class.getSimpleName(), 0, 1);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        ISolution solution;
        StrategoTerms strategoTerms = new StrategoTerms(env.getFactory());
        IStrategoTerm configSTerm = ScopeGraphMultiFileAnalysisPrimitive.getActualCurrent(tvars[0]);
        ITerm configTerm = ConstraintTerms.specialize(strategoTerms.fromStratego(configSTerm));
        SolverConfig solverConfig = SolverConfig.matcher().match(configTerm).orElseThrow(() -> new InterpreterException("Term argument is not a solver config."));
        IStrategoTerm constraintSTerm = ScopeGraphMultiFileAnalysisPrimitive.getActualCurrent(env.current());
        ICancel cancel = ScopeGraphMultiFileAnalysisPrimitive.getCancel(env.current());
        IProgress progress = ScopeGraphMultiFileAnalysisPrimitive.getProgress(env.current());
        ITerm constraintTerm = ConstraintTerms.specialize(strategoTerms.fromStratego(constraintSTerm));
        Set.Immutable constraints = Constraints.matchConstraintOrList().map(iConstraint -> CapsuleUtil.toSet(iConstraint)).match(constraintTerm).orElseThrow(() -> new InterpreterException("Current term is not a constraint."));
        NaBL2DebugConfig debugConfig = NaBL2DebugConfig.NONE;
        Fresh.Transient fresh = Fresh.Transient.of();
        SingleFileSolver solver = new SingleFileSolver(debugConfig, ScopeGraphMultiFileAnalysisPrimitive.callExternal(env, strategoTerms));
        try {
            ISolution constraintSolution;
            GraphSolution graphSolution = solver.solveGraph(BaseSolution.of(solverConfig, (Set.Immutable<IConstraint>)constraints, Unifiers.Immutable.of()), fresh::fresh, cancel, progress);
            solution = constraintSolution = solver.solve(graphSolution, fresh::fresh, cancel, progress);
        }
        catch (InterruptedException | SolverException ex) {
            throw new InterpreterException(ex);
        }
        SingleUnitResult result = SingleUnitResult.of((Iterable<? extends IConstraint>)constraints, solution, Optional.empty(), fresh.freeze());
        IMessages.Immutable messages = solution.messagesAndUnsolvedErrors();
        IStrategoTerm errors = strategoTerms.toStratego(MessageTerms.toTerms(messages.getErrors(), solution.unifier()));
        IStrategoTerm warnings = strategoTerms.toStratego(MessageTerms.toTerms(messages.getWarnings(), solution.unifier()));
        IStrategoTerm notes = strategoTerms.toStratego(MessageTerms.toTerms(messages.getNotes(), solution.unifier()));
        IStrategoTuple resultTerm = env.getFactory().makeTuple(new StrategoBlob(result), errors, warnings, notes);
        env.setCurrent(resultTerm);
        return true;
    }
}

