/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.messages;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.solver.messages.IMessages;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.iterators.Iterables2;

public abstract class Messages
implements IMessages {
    protected Messages() {
    }

    public static Set<IMessageInfo> unsolvedErrors(Iterable<? extends IConstraint> constraints) {
        return Iterables2.stream(constraints).map(c -> {
            MessageContent content = MessageContent.builder().append("Unsolved: ").append(c.getMessageInfo().getContent().withDefault(c.pp())).build();
            return c.getMessageInfo().withContent(content);
        }).collect(Collectors.toSet());
    }

    public static class Immutable
    extends Messages
    implements IMessages.Immutable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final ImList.Immutable<IMessageInfo> messages;

        private Immutable(ImList.Immutable<IMessageInfo> messages) {
            this.messages = messages;
        }

        @Override
        public List<IMessageInfo> getAll() {
            return this.messages;
        }

        @Override
        public Transient melt() {
            return new Transient(this.messages.mutableCopy());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.messages.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            return this.messages.equals(other.messages);
        }

        public static Immutable of() {
            return new Immutable(ImList.Immutable.of(new IMessageInfo[0]));
        }

        public String toString() {
            return this.messages.toString();
        }
    }

    public static class Transient
    extends Messages
    implements IMessages.Transient {
        private final ImList.Mutable<IMessageInfo> messages;

        private Transient(ImList.Mutable<IMessageInfo> messages) {
            this.messages = messages;
        }

        @Override
        public boolean add(IMessageInfo message) {
            this.messages.add(message);
            return true;
        }

        @Override
        public boolean addAll(Iterable<? extends IMessageInfo> messages) {
            boolean change = false;
            for (IMessageInfo iMessageInfo : messages) {
                change |= this.add(iMessageInfo);
            }
            return change;
        }

        @Override
        public boolean addAll(IMessages.Immutable other) {
            return this.messages.addAll(other.getAll());
        }

        @Override
        public Immutable freeze() {
            return new Immutable(this.messages.freeze());
        }

        public static Transient of() {
            return new Transient(ImList.Mutable.of(new IMessageInfo[0]));
        }

        public String toString() {
            return this.messages.toString();
        }
    }
}

