/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.constraints.sets.CDistinct;
import mb.nabl2.constraints.sets.CEvalSet;
import mb.nabl2.constraints.sets.CSubsetEq;
import mb.nabl2.constraints.sets.ISetConstraint;
import mb.nabl2.sets.IElement;
import mb.nabl2.sets.ISetProducer;
import mb.nabl2.sets.SetEvaluator;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.exceptions.CriticalEdgeDelayException;
import mb.nabl2.solver.exceptions.DelayException;
import mb.nabl2.solver.exceptions.InterruptedDelayException;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.Transform;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.StuckException;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.unit.Unit;

public class SetComponent
extends ASolver {
    private static final String NAME_OP = "NAME";
    private final TermMatch.IMatcher<ISetProducer<ITerm>> evaluator;

    public SetComponent(SolverCore core, TermMatch.IMatcher<ISetProducer<ITerm>> elems) {
        super(core);
        this.evaluator = SetEvaluator.matcher(elems);
    }

    public SolveResult solve(ISetConstraint constraint) throws DelayException {
        return constraint.matchOrThrow(ISetConstraint.CheckedCases.of(this::solve, this::solve, this::solve));
    }

    public Unit finish() {
        return Unit.unit;
    }

    private SolveResult solve(CSubsetEq constraint) throws DelayException {
        Set.Immutable<IElement<ITerm>> rightSet;
        Set.Immutable<IElement<ITerm>> leftSet;
        ITerm left = constraint.getLeft();
        ITerm right = constraint.getRight();
        if (!this.unifier().isGround(left) && this.unifier().isGround(right)) {
            Iterable<ITermVar> setVars = Iterables2.fromConcat(new Iterable[]{this.unifier().getVars(left), this.unifier().getVars(right)});
            throw new VariableDelayException(setVars);
        }
        Optional<ISetProducer<ITerm>> maybeLeftSet = this.evaluator.match(left, this.unifier());
        Optional<ISetProducer<ITerm>> maybeRightSet = this.evaluator.match(right, this.unifier());
        if (!maybeLeftSet.isPresent() || !maybeRightSet.isPresent()) {
            return SolveResult.empty();
        }
        try {
            leftSet = maybeLeftSet.get().apply();
            rightSet = maybeRightSet.get().apply();
        }
        catch (CriticalEdgeException e) {
            throw new CriticalEdgeDelayException(e);
        }
        catch (StuckException e) {
            IMessageInfo message = constraint.getMessageInfo().withDefaultContent(MessageContent.builder().append("Name set is stuck.").build());
            return SolveResult.messages(message);
        }
        catch (InterruptedException e) {
            throw new InterruptedDelayException(e);
        }
        SetMultimap.Immutable<Object, IElement<ITerm>> leftProj = SetEvaluator.project(leftSet, constraint.getProjection());
        SetMultimap.Immutable<Object, IElement<ITerm>> rightProj = SetEvaluator.project(rightSet, constraint.getProjection());
        SetMultimap.Transient result = SetMultimap.Transient.of();
        for (Object key : leftProj.keySet()) {
            if (rightProj.containsKey(key)) continue;
            result.__insert(key, leftProj.get(key));
        }
        if (result.isEmpty()) {
            return SolveResult.empty();
        }
        MessageContent content = MessageContent.builder().append(TermBuild.B.newAppl(NAME_OP, new ITerm[0])).append(" not in ").append(right).build();
        Iterable<IMessageInfo> messages = this.makeMessages(constraint.getMessageInfo().withDefaultContent(content), result.freeze().values());
        return SolveResult.messages(messages);
    }

    private SolveResult solve(CDistinct constraint) throws DelayException {
        Set.Immutable<IElement<ITerm>> set;
        ITerm setTerm = constraint.getSet();
        if (!this.unifier().isGround(setTerm)) {
            Set.Immutable<ITermVar> setVars = this.unifier().getVars(setTerm);
            throw new VariableDelayException((Iterable<ITermVar>)setVars);
        }
        Optional<ISetProducer<ITerm>> maybeSet = this.evaluator.match(setTerm, this.unifier());
        if (!maybeSet.isPresent()) {
            return SolveResult.empty();
        }
        try {
            set = maybeSet.get().apply();
        }
        catch (CriticalEdgeException e) {
            throw new CriticalEdgeDelayException(e);
        }
        catch (StuckException e) {
            IMessageInfo message = constraint.getMessageInfo().withDefaultContent(MessageContent.builder().append("Name set is stuck.").build());
            return SolveResult.messages(message);
        }
        catch (InterruptedException e) {
            throw new InterruptedDelayException(e);
        }
        SetMultimap.Immutable<Object, IElement<ITerm>> proj = SetEvaluator.project(set, constraint.getProjection());
        ArrayList<IElement<ITerm>> duplicates = new ArrayList<IElement<ITerm>>();
        for (Object key : proj.keySet()) {
            Set.Immutable values = proj.get(key);
            if (values.size() <= 1) continue;
            duplicates.addAll((Collection<IElement<ITerm>>)values);
        }
        if (duplicates.isEmpty()) {
            return SolveResult.empty();
        }
        MessageContent content = MessageContent.builder().append(TermBuild.B.newAppl(NAME_OP, new ITerm[0])).append(" has duplicates in ").append(setTerm).build();
        Iterable<IMessageInfo> messages = this.makeMessages(constraint.getMessageInfo().withDefaultContent(content), duplicates);
        return SolveResult.messages(messages);
    }

    private SolveResult solve(CEvalSet constraint) throws DelayException {
        Set.Immutable<IElement<ITerm>> set;
        ITerm setTerm = constraint.getSet();
        if (!this.unifier().isGround(setTerm)) {
            Set.Immutable<ITermVar> setVars = this.unifier().getVars(setTerm);
            throw new VariableDelayException((Iterable<ITermVar>)setVars);
        }
        Optional<ISetProducer<ITerm>> maybeSet = this.evaluator.match(setTerm, this.unifier());
        if (!maybeSet.isPresent()) {
            return SolveResult.empty();
        }
        try {
            set = maybeSet.get().apply();
        }
        catch (CriticalEdgeException e) {
            throw new CriticalEdgeDelayException(e);
        }
        catch (StuckException e) {
            IMessageInfo message = constraint.getMessageInfo().withDefaultContent(MessageContent.builder().append("Name set is stuck.").build());
            return SolveResult.messages(message);
        }
        catch (InterruptedException e) {
            throw new InterruptedDelayException(e);
        }
        List elements = set.stream().map(i -> (ITerm)i.getValue()).collect(Collectors.toList());
        return SolveResult.constraints(CEqual.of(constraint.getResult(), TermBuild.B.newList(elements), constraint.getMessageInfo()));
    }

    private Iterable<IMessageInfo> makeMessages(IMessageInfo template, Collection<IElement<ITerm>> elements) {
        boolean nameOrigin = TermMatch.M.appl0(NAME_OP).match(template.getOriginTerm(), this.unifier()).isPresent();
        if (nameOrigin && !elements.isEmpty()) {
            return elements.stream().map(e -> {
                Function1<ITerm, ITerm> f = Transform.T.sometd(t -> TermMatch.M.appl0(NAME_OP, a -> (ITerm)e.getName()).match((ITerm)t, this.unifier()));
                return MessageInfo.of(template.getKind(), template.getContent().apply(f), (ITerm)e.getPosition());
            }).collect(Collectors.toList());
        }
        IListTerm es = TermBuild.B.newList(elements.stream().map(e -> (ITerm)e.getName()).collect(Collectors.toList()));
        Function1<ITerm, ITerm> f = Transform.T.sometd(t -> TermMatch.M.appl0(NAME_OP, a -> es).match((ITerm)t, this.unifier()));
        return Iterables2.singleton(MessageInfo.of(template.getKind(), template.getContent().apply(f), template.getOriginTerm()));
    }
}

